/* 
 *  $Id: avalanche_regs.h,v 1.1.1.1 2003/06/23 22:18:41 jharrell Exp $
 *  Avalanche Register Descriptions
 *
 *  Jeff Harrell, jharrell@ti.com
 *  2000 (c) Texas Instruments Inc.
 */

#ifndef __AVALANCHE_REGS_H
#define __AVALANCHE_REGS_H

#include <asm/addrspace.h>
#include <linux/config.h>

/*----------------------------------------*/
/* Base offsets within the Avalanche ASIC */
/*----------------------------------------*/

#define BBIF_SPACE0     (KSEG1ADDR(0x01000000))
#define BBIF_SPACE1     (KSEG1ADDR(0x01800000))
#define BBIF_CONTROL    (KSEG1ADDR(0x02000000))
#define ATM_SAR_BASE    (KSEG1ADDR(0x03000000))
#define USB_MCU_BASE    (KSEG1ADDR(0x03400000))
#define DES_BASE        (KSEG1ADDR(0x08600000))
#define ETH_MACA_BASE   (KSEG1ADDR(0x08610000))
#define ETH_MACB_BASE   (KSEG1ADDR(0x08612800))
#define MEM_CTRLR_BASE  (KSEG1ADDR(0x08610800))
#define GPIO_BASE       (KSEG1ADDR(0x08610900))
#define CLK_CTRL_BASE   (KSEG1ADDR(0x08610A00))
#define WATCH_DOG_BASE  (KSEG1ADDR(0x08610B00))
#define TMR1_BASE       (KSEG1ADDR(0x08610C00))
#define TRM2_BASE       (KSEG1ADDR(0x08610D00))
#define UARTA_BASE      (KSEG1ADDR(0x08610E00))
#define UARTB_BASE      (KSEG1ADDR(0x08610F00))
#define I2C_BASE        (KSEG1ADDR(0x08611000))
#define DEV_ID_BASE     (KSEG1ADDR(0x08611100))
#define USB_BASE        (KSEG1ADDR(0x08611200))
#define PCI_CONFIG_BASE (KSEG1ADDR(0x08611300))
#define DMA_BASE        (KSEG1ADDR(0x08611400))
#define RESET_CTRL_BASE (KSEG1ADDR(0x08611600))
#define DSL_IF_BASE     (KSEG1ADDR(0x08611B00))
#define INT_CTL_BASE    (KSEG1ADDR(0x08612400)) 
#define PHY_BASE        (KSEG1ADDR(0x1E000000))

/*---------------------------------*/
/* Device ID, chip version number  */
/*---------------------------------*/

#define AVALANCHE_CHVN  (*(volatile unsigned int *)(DEV_ID_BASE+0x14))
#define AVALANCHE_DEVID1 (*(volatile unsigned int *)(DEV_ID_BASE+0x18))
#define AVALANCHE_DEVID2 (*(volatile unsigned int *)(DEV_ID_BASE+0x1C))

/*----------------------------------*/
/* Reset Control VW changed to ptrs */
/*----------------------------------*/

#define AVALANCHE_PRCR  (*(volatile unsigned int *)(RESET_CTRL_BASE + 0x0))  /* Peripheral reset control */
#define AVALANCHE_SWRCR (*(volatile unsigned int *)(RESET_CTRL_BASE + 0x4))  /* Software reset control   */
#define AVALANCHE_RSR   (*(volatile unsigned int *)(RESET_CTRL_BASE + 0x8))  /* Reset status register    */

/* reset control bits */

#define AV_RST_UART0    (1<<0)    /* Brings UART0 out of reset              */
#define AV_RST_UART1    (1<<1)    /* Brings UART1 out of reset              */
#define AV_RST_IICM     (1<<2)    /* Brings the I2CM out of reset           */
#define AV_RST_TIMER0   (1<<3)    /* Brings Timer 0 out of reset            */
#define AV_RST_TIMER1   (1<<4)    /* Brings Timer 1 out of reset            */
#define AV_RST_DES      (1<<5)    /* Brings the DES module out of reset     */
#define AV_RST_GPIO     (1<<6)    /* Brings the GPIO module out of reset (see note below) */
/*
  JAH NOTE JAH NOTE JAH NOTE JAH NOTE JAH NOTE JAH NOTE JAH NOTE JAH NOTE
       If you reset the GPIO interface all of the directions (i/o) of the UART B
       interface pins are inputs and must be reconfigured so as not to lose the 
       serial console interface
  JAH NOTE JAH NOTE JAH NOTE JAH NOTE JAH NOTE JAH NOTE JAH NOTE JAH NOTE
*/
#define AV_RST_BBIF     (1<<7)    /* Brings the Broadband interface out of reset */
#define AV_RST_USB      (1<<8)    /* Brings the USB module out of reset     */
#define AV_RST_SAR      (1<<9)    /* Brings the SAR out of reset            */
#define AV_RST_HDLC     (1<<10)   /* Brings the HDLC module out of reset    */
#define AV_RST_PCI      (1<<16)   /* Brings the PCI module out of reset     */
#define AV_RST_ETH_MAC0 (1<<17)   /* Brings the Ethernet MAC0 out of reset  */
#define AV_RST_PICO_DMA (1<<18)   /* Brings the PICO DMA module out of reset */
#define AV_RST_BIST     (1<<19)   /* Brings the BIST module out of reset    */
#define AV_RST_DSP      (1<<20)   /* Brings the DSP sub system out of reset */
#define AV_RST_ETH_MAC1 (1<<21)   /* Brings the Ethernet MAC1 out of reset  */

/*----------------------*/
/* Physical interfaces  */
/*----------------------*/

/* Phy loopback */
#define PHY_LOOPBACK    1


/* Phy 0 */
#define PHY0BASE        (PHY_BASE)
#define PHY0RST         (*(volatile unsigned char *) (PHY0BASE))      /* reset   */
#define PHY0CTRL        (*(volatile unsigned char *) (PHY0BASE+0x5))  /* control */
#define PHY0RACPCTRL    (*(volatile unsigned char *) (PHY0BASE+0x50)) /* RACP control/status */ 
#define PHY0TACPCTRL    (*(volatile unsigned char *) (PHY0BASE+0x60)) /* TACP idle/unassigned cell hdr */
#define PHY0RACPINT     (*(volatile unsigned char *) (PHY0BASE+0x51)) /* RACP interrupt enable/Status */


/* Phy 1 */

#define PHY1BASE        (PHY_BASE + 0x100000)
#define PHY1RST         (*(volatile unsigned char *) (PHY1BASE))      /* reset   */
#define PHY1CTRL        (*(volatile unsigned char *) (PHY1BASE+0x5))  /* control */
#define PHY1RACPCTRL    (*(volatile unsigned char *) (PHY1BASE+0x50)) 
#define PHY1TACPCTRL    (*(volatile unsigned char *) (PHY1BASE+0x60)) 
#define PHY1RACPINT     (*(volatile unsigned char *) (PHY1BASE+0x51)) 

/* Phy 2 */

#define PHY2BASE        (PHY_BASE + 0x200000)
#define PHY2RST         (*(volatile unsigned char *) (PHY2BASE))      /* reset   */
#define PHY2CTRL        (*(volatile unsigned char *) (PHY2BASE+0x5))  /* control */
#define PHY2RACPCTRL    (*(volatile unsigned char *) (PHY2BASE+0x50)) 
#define PHY2TACPCTRL    (*(volatile unsigned char *) (PHY2BASE+0x60)) 
#define PHY2RACPINT     (*(volatile unsigned char *) (PHY2BASE+0x51)) 

/*-------------------*/
/* Avalanche ATM SAR */
/*-------------------*/

#define AVSAR_SYSCONFIG    (*(volatile unsigned int*)(ATM_SAR_BASE+0x00000000)) /* SAR system config register    */
#define AVSAR_SYSSTATUS    (*(volatile unsigned int*)(ATM_SAR_BASE+0x00000004)) /* SAR system status register    */
#define AVSAR_INT_ENABLE   (*(volatile unsigned int*)(ATM_SAR_BASE+0x00000008)) /* SAR interrupt enable register */
#define AVSAR_CONN_VPI_VCI (*(volatile unsigned int*)(ATM_SAR_BASE+0x0000000c)) /* VPI/VCI connection config     */
#define AVSAR_CONN_CONFIG  (*(volatile unsigned int*)(ATM_SAR_BASE+0x00000010)) /* Connection config register    */
#define AVSAR_OAM_CONFIG   (*(volatile unsigned int*)(ATM_SAR_BASE+0x00000018)) /* OAM configuration register    */

/* Transmit completion ring registers */

#define AVSAR_TCRAPTR       (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000100))
#define AVSAR_TCRASIZE      (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000104))
#define AVSAR_TCRAINTTHRESH (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000108))
#define AVSAR_TCRATOTENT    (*(volatile unsigned int *)(ATM_SAR_BASE+0x0000010c))
#define AVSAR_TCRAFREEENT   (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000110))
#define AVSAR_TCRAPENDENT   (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000114))
#define AVSAR_TCRAENTINC    (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000118))
#define AVSAR_TCRBPTR       (*(volatile unsigned int *)(ATM_SAR_BASE+0x0000011c))
#define AVSAR_TCRBSIZE      (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000120))
#define AVSAR_TCRBINTTHRESH (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000124))
#define AVSAR_TCRBTOTENT    (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000128))
#define AVSAR_TCRBFREEENT   (*(volatile unsigned int *)(ATM_SAR_BASE+0x0000012c))
#define AVSAR_TCRBPENDENT   (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000130))
#define AVSAR_TCRBENTINC    (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000134))

/* Transmit Queue Packet registers */
#define AVSAR_TXQUEUE_PKT0  (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000140))
#define AVSAR_TXQUEUE_PKT1  (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000144))
#define AVSAR_TXQUEUE_PKT2  (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000148))
#define AVSAR_TX_FLUSH      (*(volatile unsigned int *)(ATM_SAR_BASE+0x0000014C))
/* Receive completion ring registers */

#define AVSAR_RCRAPTR       (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000200))
#define AVSAR_RCRASIZE      (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000204))
#define AVSAR_RCRAINTTHRESH (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000208))
#define AVSAR_RCRATOTENT    (*(volatile unsigned int *)(ATM_SAR_BASE+0x0000020c))
#define AVSAR_RCRAFREEENT   (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000210))
#define AVSAR_RCRAPENDENT   (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000214))
#define AVSAR_RCRAENTINC    (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000218))
#define AVSAR_RCRBPTR       (*(volatile unsigned int *)(ATM_SAR_BASE+0x0000021c))
#define AVSAR_RCRBSIZE      (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000220))
#define AVSAR_RCRBINTTHRESH (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000224))
#define AVSAR_RCRBTOTENT    (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000228))
#define AVSAR_RCRBFREEENT   (*(volatile unsigned int *)(ATM_SAR_BASE+0x0000022c))
#define AVSAR_RCRBPENDENT   (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000230))
#define AVSAR_RCRBENTINC    (*(volatile unsigned int *)(ATM_SAR_BASE+0x00000234))

#define AVSAR_RXFBL_ADD0    (*(volatile unsigned int*)(ATM_SAR_BASE+0x00000240)) /* Rx Free buffer list add 0  */
#define AVSAR_RXFBL_ADD1    (*(volatile unsigned int*)(ATM_SAR_BASE+0x00000244)) /* Rx Free buffer list add 1  */
#define AVSAR_RXFBL_ADD2    (*(volatile unsigned int*)(ATM_SAR_BASE+0x00000248)) /* Rx Free buffer list add 2  */
#define AVSAR_RXFBLSIZE_0   (*(volatile unsigned int*)(ATM_SAR_BASE+0x0000028c)) /* Rx Free buffer list size 0 */
#define AVSAR_RXFBLSIZE_1   (*(volatile unsigned int*)(ATM_SAR_BASE+0x0000029c)) /* Rx Free buffer list size 1 */
#define AVSAR_RXFBLSIZE_2   (*(volatile unsigned int*)(ATM_SAR_BASE+0x000002ac)) /* Rx Free buffer list size 2 */
#define AVSAR_RXFBLSIZE_3   (*(volatile unsigned int*)(ATM_SAR_BASE+0x000002bc)) /* Rx Free buffer list size 3 */


#if defined(CONFIG_MIPS_EVM3D) || defined(CONFIG_MIPS_AR5D01) || defined(CONFIG_MIPS_AR5W01)

#define AVSAR_SAR_FREQUENCY (*(volatile unsigned int*)(ATM_SAR_BASE+0x00010480))
#define AVSAR_OAM_CC_SINK   (*(volatile unsigned int*)(ATM_SAR_BASE+0x00010484))
#define AVSAR_OAM_AIS_RDI_RX (*(volatile unsigned int*)(ATM_SAR_BASE+0x00010488))
#define AVSAR_OAM_CPID0      (*(volatile unsigned int*)(ATM_SAR_BASE+0x000104E0))
#define AVSAR_OAM_LLID0      (*(volatile unsigned int*)(ATM_SAR_BASE+0x000104F0))
#define AVSAR_OAM_CPID1      (*(volatile unsigned int*)(ATM_SAR_BASE+0x000104E4))
#define AVSAR_OAM_LLID1      (*(volatile unsigned int*)(ATM_SAR_BASE+0x000104F4))
#define AVSAR_OAM_CPID2      (*(volatile unsigned int*)(ATM_SAR_BASE+0x000104E8))
#define AVSAR_OAM_LLID2      (*(volatile unsigned int*)(ATM_SAR_BASE+0x000104F8))
#define AVSAR_OAM_CPID3      (*(volatile unsigned int*)(ATM_SAR_BASE+0x000104EC))
#define AVSAR_OAM_LLID3      (*(volatile unsigned int*)(ATM_SAR_BASE+0x000104FC))
#define AVSAR_OAM_CORR_TAG      (*(volatile unsigned int*)(ATM_SAR_BASE+0x00010500))
#define AVSAR_OAM_FAR_COUNT      (*(volatile unsigned int*)(ATM_SAR_BASE+0x00010520))
#define AVSAR_OAM_NEAR_COUNT      (*(volatile unsigned int*)(ATM_SAR_BASE+0x00010540))
#define AVSAR_OAM_CONFIG_REG      (*(volatile unsigned int*)(ATM_SAR_BASE+0x00000018))
#define AVSAR_FAIRNESS_REG   (*(volatile unsigned int*)(ATM_SAR_BASE+0x000104B8))
#define AVSAR_UBR_PCR_REG   (*(volatile unsigned int*)(ATM_SAR_BASE+0x00010490))


/*

#define OAM_CPID_ADD  0xa30104e0

#define OAM_LLID_ADD  0xa30104f0

#define OAM_LLID_VAL  0xffffffff

#define OAM_CORR_TAG  0xa3010500

#define OAM_FAR_COUNT_ADD 0xa3010520

#define OAM_NEAR_COUNT_ADD 0xa3010540

#define OAM_CONFIG_REG_ADD 0xa3000018
*/


#else /* CONFIG_MIPS_EVM3 || CONFIG_MIPS_ACPEP */

#define AVSAR_SAR_FREQUENCY (*(volatile unsigned int*)(ATM_SAR_BASE+0x00012000))
#define AVSAR_OAM_CC_SINK   (*(volatile unsigned int*)(ATM_SAR_BASE+0x00012004))
#define AVSAR_OAM_AIS_RDI_RX (*(volatile unsigned int*)(ATM_SAR_BASE+0x00012008))
#define AVSAR_OAM_CPID      (*(volatile unsigned int*)(ATM_SAR_BASE+0x00012300))

#endif /* CONFIG_MIPS_EVM3D || CONFIG_MIPS_AR5D01 || CONFIG_MIPS_AR5W01 */


#define AVSAR_STATE_RAM     (ATM_SAR_BASE + 0x010000) /* SAR state RAM */
#define AVSAR_PDSP_BASE     (ATM_SAR_BASE + 0x020000) /* SAR PDSP base address   */
#define AVSAR_TXDMA_BASE    (ATM_SAR_BASE + 0x030000) /* Transmit DMA state base */ 
#define AVSAR_TDMASTATE6    0x18                      /* Transmit DMA state word 6 */
#define AVSAR_RXDMA_BASE    (ATM_SAR_BASE + 0x040000) /* Receive  DMA state base */
#define AVSAR_RDMASTATE0    0x0                       /* Receive  DMA state word 0 */

/*------------------------------------------*/
/* DSL Interface                            */
/*------------------------------------------*/

#define AVDSL_TX_EN          (*(volatile unsigned int *)(DSL_IF_BASE + 0x00000000))
#define AVDSL_RX_EN          (*(volatile unsigned int *)(DSL_IF_BASE + 0x00000004))
#define AVDSL_POLL           (*(volatile unsigned int *)(DSL_IF_BASE + 0x00000008))

/* Fast */

#define AVDSL_TX_FIFO_ADDR0  (*(volatile unsigned int *)(DSL_IF_BASE + 0x0000000C))
#define AVDSL_TX_FIFO_BASE0  (*(volatile unsigned int *)(DSL_IF_BASE + 0x00000010))
#define AVDSL_TX_FIFO_LEN0   (*(volatile unsigned int *)(DSL_IF_BASE + 0x00000014))
#define AVDSL_TX_FIFO_PR0    (*(volatile unsigned int *)(DSL_IF_BASE + 0x00000018))
#define AVDSL_RX_FIFO_ADDR0  (*(volatile unsigned int *)(DSL_IF_BASE + 0x0000001C))
#define AVDSL_RX_FIFO_BASE0  (*(volatile unsigned int *)(DSL_IF_BASE + 0x00000020))
#define AVDSL_RX_FIFO_LEN0   (*(volatile unsigned int *)(DSL_IF_BASE + 0x00000024))
#define AVDSL_RX_FIFO_PR0    (*(volatile unsigned int *)(DSL_IF_BASE + 0x00000028))

/* Interleaved */

#define AVDSL_TX_FIFO_ADDR1  (*(volatile unsigned int *)(DSL_IF_BASE + 0x0000002C))
#define AVDSL_TX_FIFO_BASE1  (*(volatile unsigned int *)(DSL_IF_BASE + 0x00000030))
#define AVDSL_TX_FIFO_LEN1   (*(volatile unsigned int *)(DSL_IF_BASE + 0x00000034))
#define AVDSL_TX_FIFO_PR1    (*(volatile unsigned int *)(DSL_IF_BASE + 0x00000038))
#define AVDSL_RX_FIFO_ADDR1  (*(volatile unsigned int *)(DSL_IF_BASE + 0x0000003C))
#define AVDSL_RX_FIFO_BASE1  (*(volatile unsigned int *)(DSL_IF_BASE + 0x00000040))
#define AVDSL_RX_FIFO_LEN1   (*(volatile unsigned int *)(DSL_IF_BASE + 0x00000044))
#define AVDSL_RX_FIFO_PR1    (*(volatile unsigned int *)(DSL_IF_BASE + 0x00000048))

/*------------------------------------------*/
/* Broadband I/F                            */
/*------------------------------------------*/

#define AVBBIF_BBIF_CNTRL    (*(volatile unsigned int *)(BBIF_CONTROL + 0x00000000))
#define AVBBIF_ADDR_TRANS_0  (*(volatile unsigned int *)(BBIF_CONTROL + 0x00000004))
#define AVBBIF_ADDR_TRANS_1  (*(volatile unsigned int *)(BBIF_CONTROL + 0x00000008))
#define AVBBIF_ADDR_XB_MX_BL (*(volatile unsigned int *)(BBIF_CONTROL + 0x0000000C))
#define AVBBIF_INFIFO_LVL    (*(volatile unsigned int *)(BBIF_CONTROL + 0x00000010))
#define AVBBIF_OUTFIFO_LVL   (*(volatile unsigned int *)(BBIF_CONTROL + 0x00000014))

#define AVBBIF_DISABLED    0x0
#define AVBBIF_LBT4040_INT 0x1
#define AVBBIF_XBUS        0x2
#define AVBBIF_LBT4040_EXT 0x4

#define AVBBIF_ADDR_MASK0   0xff000000 /* handles upper bits of BBIF 0 address */
#define AVBBIF_ADDR_MASK1   0xff800000 /* handles upper bits of BBIF 1 address */
#define AVBBIF_TRANS_MASK   0xff000000
/*------------------------------------------*/
/* GPIO I/F                                 */
/*------------------------------------------*/

#define GPIO_DATA_INPUT      (*(volatile unsigned int *)(GPIO_BASE + 0x00000000))
#define GPIO_DATA_OUTPUT     (*(volatile unsigned int *)(GPIO_BASE + 0x00000004))
#define GPIO_DATA_DIR        (*(volatile unsigned int *)(GPIO_BASE + 0x00000008)) /* 0=output 1=input  */
#define GPIO_DATA_ENABLE     (*(volatile unsigned int *)(GPIO_BASE + 0x0000000C)) /* 0=GPIO Mux 1=GPIO */

#define GPIO_0 (1<<21)
#define GPIO_1 (1<<22)
#define GPIO_2 (1<<23)
#define GPIO_3 (1<<24)
#define EINT_1 (1<<18)

/*
  JAH NOTE JAH NOTE JAH NOTE JAH NOTE JAH NOTE JAH NOTE JAH NOTE JAH NOTE
       If you reset the GPIO interface all of the directions (i/o) of the UART B
       interface pins are inputs and must be reconfigured so as not to lose the 
       serial console interface
  JAH NOTE JAH NOTE JAH NOTE JAH NOTE JAH NOTE JAH NOTE JAH NOTE JAH NOTE
*/

/*------------------------------------------*/
/* CLK_CTRL                                 */
/*------------------------------------------*/
#define PERIPH_CLK_CTL       (*(volatile unsigned int *)(CLK_CTRL_BASE + 0x00000004))

#define PCLK_0_HALF_VBUS     (0<<16)
#define PCLK_EQ_INPUT        (1<<16)
#define BBIF_CLK_HALF_VBUS   (0<<17)
#define BBIF_CLK_EQ_VBUS     (1<<17)
#define BBIF_CLK_EQ_BBCLK    (3<<17)
#define DSP_MODCLK_DSPCLKI   (0<<20)
#define DSP_MODCLK_REFCLKI   (1<<20)
#define USB_CLK_EQ_USBCLKI   (0<<21)
#define USB_CLK_EQ_REFCLKI   (1<<21)

/*------------------------------------------*/
/* PCI Control Registers                    */
/*------------------------------------------*/
#define	PCIC_CONTROL		(*(volatile unsigned int *)(PCI_CONFIG_BASE))
#define		PCIC_CONTROL_CFG_DONE				(1<<0)
#define		PCIC_CONTROL_DIS_SLAVE_TO			(1<<1)
#define		PCIC_CONTROL_FORCE_DELAY_READ		(1<<2)
#define		PCIC_CONTROL_FORCE_DELAY_READ_LINE	(1<<3)
#define		PCIC_CONTROL_FORCE_DELAY_READ_MULT	(1<<4)
#define		PCIC_CONTROL_MEM_SPACE_EN			(1<<5)
#define		PCIC_CONTROL_MEM_MASK				(1<<6)
#define		PCIC_CONTROL_IO_SPACE_EN			(1<<7)
#define		PCIC_CONTROL_IO_MASK				(1<<8)
/*			PCIC_CONTROL_RESERVED				(1<<9)	*/
#define		PCIC_CONTROL_BASE0_EN				(1<<10)
#define		PCIC_CONTROL_BASE1_EN				(1<<11)
#define		PCIC_CONTROL_BASE2_EN				(1<<12)
#define		PCIC_CONTROL_HOLD_MASTER_WRITE		(1<<13)
#define		PCIC_CONTROL_ARBITER_EN				(1<<14)
#define	PCIC_INT_SOURCE		(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x00000004))
#define		PCIC_INT_SOURCE_PWR_MGMT			(1<<0)
#define		PCIC_INT_SOURCE_PCI_TARGET			(1<<1)
#define		PCIC_INT_SOURCE_PCI_MASTER			(1<<2)
#define		PCIC_INT_SOURCE_POWER_WAKEUP		(1<<3)
#define		PCIC_INT_SOURCE_PMEIN				(1<<4)
/*			PCIC_INT_SOURCE_RESERVED			(1<<5) */
/*			PCIC_INT_SOURCE_RESERVED			(1<<6) */
#define		PCIC_INT_SOURCE_PIC_INTA			(1<<7)
#define		PCIC_INT_SOURCE_PIC_INTB			(1<<8)
#define		PCIC_INT_SOURCE_PIC_INTC			(1<<9)
#define		PCIC_INT_SOURCE_PIC_INTD			(1<<10)
#define		PCIC_INT_SOURCE_SOFT_INT0			(1<<11)
#define		PCIC_INT_SOURCE_SOFT_INT1			(1<<12)
#define		PCIC_INT_SOURCE_SOFT_INT2			(1<<13)
#define		PCIC_INT_SOURCE_SOFT_INT3			(1<<14)
#define	PCIC_INT_CLEAR		(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x00000008))
#define		PCIC_INT_CLEAR_PM					(1<<0)
#define		PCIC_INT_CLEAR_PCI_TARGET			(1<<1)
#define		PCIC_INT_CLEAR_PCI_MASTER			(1<<2)
/*			PCIC_INT_CLEAR_RESERVED				(1<<3)	*/
#define		PCIC_INT_CLEAR_PMEIN				(1<<4)
/*			PCIC_INT_CLEAR_RESERVED				(1<<5)	*/
/*			PCIC_INT_CLEAR_RESERVED				(1<<6)	*/
#define		PCIC_INT_CLEAR_PCI_INTA				(1<<7)
#define		PCIC_INT_CLEAR_PCI_INTB				(1<<8)
#define		PCIC_INT_CLEAR_PCI_INTC				(1<<9)
#define		PCIC_INT_CLEAR_PCI_INTD				(1<<10)
#define		PCIC_INT_CLEAR_SOFT_INT0			(1<<11)
#define		PCIC_INT_CLEAR_SOFT_INT1			(1<<12)
#define		PCIC_INT_CLEAR_SOFT_INT2			(1<<13)
#define		PCIC_INT_CLEAR_SOFT_INT3			(1<<14)
#define	PCIC_INT_EN_AVAL	(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x0000000c))
#define		PCIC_INT_EN_AVAL_PM					(1<<0)
#define		PCIC_INT_EN_AVAL_PCI_TARGET			(1<<1)
#define		PCIC_INT_EN_AVAL_PCI_MASTER			(1<<2)
/*			PCIC_INT_EN_AVAL_RESERVED			(1<<3)	*/
#define		PCIC_INT_EN_AVAL_PMEIN				(1<<4)
/*			PCIC_INT_EN_AVAL_RESERVED			(1<<5)	*/
/*			PCIC_INT_EN_AVAL_RESERVED			(1<<6)	*/
#define		PCIC_INT_EN_AVAL_PCI_INTA			(1<<7)
#define		PCIC_INT_EN_AVAL_PCI_INTB			(1<<8)
#define		PCIC_INT_EN_AVAL_PCI_INTC			(1<<9)
#define		PCIC_INT_EN_AVAL_PCI_INTD			(1<<10)
#define		PCIC_INT_EN_AVAL_SOFT_INT0			(1<<11)
#define		PCIC_INT_EN_AVAL_SOFT_INT1			(1<<12)
#define		PCIC_INT_EN_AVAL_SOFT_INT2			(1<<13)
#define		PCIC_INT_EN_AVAL_SOFT_INT3			(1<<14)
#define	PCIC_INT_EN_PCI			(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x00000010))
#define		PCIC_INT_EN_PCI_PM					(1<<0)
#define		PCIC_INT_EN_PCI_PCI_TARGET			(1<<1)
#define		PCIC_INT_EN_PCI_PCI_MASTER			(1<<2)
/*			PCIC_INT_EN_PCI_RESERVED			(1<<3)	*/
#define		PCIC_INT_EN_PCI_PMEIN				(1<<4)
/*			PCIC_INT_EN_PCI_RESERVED			(1<<5)	*/
/*			PCIC_INT_EN_PCI_RESERVED			(1<<6)	*/
#define		PCIC_INT_EN_PCI_PCI_INTA			(1<<7)
#define		PCIC_INT_EN_PCI_PCI_INTB			(1<<8)
#define		PCIC_INT_EN_PCI_PCI_INTC			(1<<9)
#define		PCIC_INT_EN_PCI_PCI_INTD			(1<<10)
#define		PCIC_INT_EN_PCI_SOFT_INT0			(1<<11)
#define		PCIC_INT_EN_PCI_SOFT_INT1			(1<<12)
#define		PCIC_INT_EN_PCI_SOFT_INT2			(1<<13)
#define		PCIC_INT_EN_PCI_SOFT_INT3			(1<<14)
#define	PCIC_INT_SWSET		(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x00000014))
#define		PCIC_INT_SWSET_SOFT_INT0			(1<<0)
#define		PCIC_INT_SWSET_SOFT_INT1			(1<<1)
#define		PCIC_INT_SWSET_SOFT_INT2			(1<<2)
#define		PCIC_INT_SWSET_SOFT_INT3			(1<<3)
#define	PCIC_PM_CTL			(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x00000018))
#define		PCIC_PM_CTL_PWR_STATE_MASK			(0x02)
/*			PCIC_PM_CTL_RESERVED				(1<<2) */
/*			PCIC_PM_CTL_RESERVED				(1<<3) */
/*			PCIC_PM_CTL_RESERVED				(1<<4) */
/*			PCIC_PM_CTL_RESERVED				(1<<5) */
/*			PCIC_PM_CTL_RESERVED				(1<<6) */
/*			PCIC_PM_CTL_RESERVED				(1<<7) */
/*			PCIC_PM_CTL_RESERVED				(1<<8) */
/*			PCIC_PM_CTL_RESERVED				(1<<9) */
#define		PCIC_PM_CTL_PWR_SUPPORT				(1<<10)
#define		PCIC_PM_CTL_PMEIN					(1<<11)
#define		PCIC_PM_CTL_CAP_MASK	(*(volatile unsigned short int *)(PCI_CONFIG_BASE + 0x0000001a))
#define	PCIC_PM_CONSUME		(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x0000001c))
#define		PCIC_PM_CONSUME_D0		(*(volatile unsigned char *)(PCI_CONFIG_BASE + 0x0000001c))
#define		PCIC_PM_CONSUME_D1		(*(volatile unsigned char *)(PCI_CONFIG_BASE + 0x0000001d))
#define		PCIC_PM_CONSUME_D2		(*(volatile unsigned char *)(PCI_CONFIG_BASE + 0x0000001e))
#define		PCIC_PM_CONSUME_D3		(*(volatile unsigned char *)(PCI_CONFIG_BASE + 0x0000001f))
#define	PCIC_PM_DISSAPATED	(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x00000020))
#define		PCIC_PM_DISSAPATED_D0	(*(volatile unsigned char *)(PCI_CONFIG_BASE + 0x00000020))
#define		PCIC_PM_DISSAPATED_D1	(*(volatile unsigned char *)(PCI_CONFIG_BASE + 0x00000021))
#define		PCIC_PM_DISSAPATED_D2	(*(volatile unsigned char *)(PCI_CONFIG_BASE + 0x00000022))
#define		PCIC_PM_DISSAPATED_D3	(*(volatile unsigned char *)(PCI_CONFIG_BASE + 0x00000023))
#define	PCIC_PM_DATA_SCALE	(*(volatile unsigned short int *)(PCI_CONFIG_BASE + 0x00000024))
#define	PCIC_VEND_DEV_ID	(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x00000028))
#define	PCIC_SUB_VEND_DEV_ID	(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x0000002c))
#define	PCIC_CLASS_REV_ID	(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x00000030))
#define	PCIC_MAX_MIN		(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x00000034))
#define	PCIC_MAST_MEM_AT0	(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x0000003c))
#define	PCIC_MAST_MEM_AT1	(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x00000040))
#define	PCIC_MAST_MEM_AT2	(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x00000044))
#define	PCIC_SLAVE_MASK0	(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x0000004c))
#define	PCIC_SLAVE_MASK1	(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x00000050))
#define	PCIC_SLAVE_MASK2	(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x00000054))
#define	PCIC_SLAVE_BASE_AT0	(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x00000058))
#define	PCIC_SLAVE_BASE_AT1	(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x0000005c))
#define	PCIC_SLAVE_BASE_AT2	(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x00000060))
#define	PCIC_CONF_COMMAND	(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x00000090))
#define	PCIC_CONF_ADDR		(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x00000094))
#define	PCIC_CONF_DATA		(*(volatile unsigned int *)(PCI_CONFIG_BASE + 0x00000098))

/*------------------------------------------*/
/* IIC_INTERFACE                            */
/*------------------------------------------*/
#define I2C_DATA_HI          (*(volatile unsigned int *)(I2C_BASE + 0x0))
#define I2C_DATA_LOW         (*(volatile unsigned int *)(I2C_BASE + 0x4))
#define I2C_CONFIG           (*(volatile unsigned int *)(I2C_BASE + 0x8))
#define I2C_DATA_READ        (*(volatile unsigned int *)(I2C_BASE + 0xC))
#define I2C_CLOCK_DIV        (*(volatile unsigned int *)(I2C_BASE + 0x10))

#define I2CWRITE      0x200
#define I2CREAD       0x300
#define I2C_END_BURST 0x400

/* read bits */
#define I2C_READ_ERROR    0x8000
#define I2C_READ_COMPLETE 0x4000
#define I2C_READ_BUSY     0x2000

/* device types */
#define I2C_IO_EXPANDER      0x2
#define I2C_RTC              0xd

/* device Addresses on I2C bus (EVM3) */
#define SEVEN_SEGMENT_DISP    0x23   /* Device type = 0x2, Addr = 3 */
#define EVM3_RTC              0xd0   /* Device type = 0xd, Addr = 0 */
#define EVM3_RTC_I2C_ADDR      0x0

/*------------------------------------------*/
/* Ethernet MAC register offset definitions */
/*------------------------------------------*/
#define VMAC_DMACONFIG(X)      (*(volatile unsigned int *)(X + 0x00000000))
#define VMAC_INTSTS(X)         (*(volatile unsigned int *)(X + 0x00000004))
#define VMAC_INTMASK(X)        (*(volatile unsigned int *)(X + 0x00000008))

#define VMAC_WRAPCLK(X)        (*(volatile unsigned int *)(X + 0x00000340))
#define VMAC_STATSBASE(X)      (*(volatile unsigned int *)(X + 0x00000400))
 
#define VMAC_TCRPTR(X)         (*(volatile unsigned int *)(X + 0x00000100))
#define VMAC_TCRSIZE(X)        (*(volatile unsigned int *)(X + 0x00000104))
#define VMAC_TCRINTTHRESH(X)   (*(volatile unsigned int *)(X + 0x00000108))
#define VMAC_TCRTOTENT(X)      (*(volatile unsigned int *)(X + 0x0000010C))
#define VMAC_TCRFREEENT(X)     (*(volatile unsigned int *)(X + 0x00000110))
#define VMAC_TCRPENDENT(X)     (*(volatile unsigned int *)(X + 0x00000114))
#define VMAC_TCRENTINC(X)      (*(volatile unsigned int *)(X + 0x00000118))
#define VMAC_TXISRPACE(X)      (*(volatile unsigned int *)(X + 0x0000011c))


#define VMAC_TDMASTATE0(X)     (*(volatile unsigned int *)(X + 0x00000120))
#define VMAC_TDMASTATE1(X)     (*(volatile unsigned int *)(X + 0x00000124))
#define VMAC_TDMASTATE2(X)     (*(volatile unsigned int *)(X + 0x00000128))
#define VMAC_TDMASTATE3(X)     (*(volatile unsigned int *)(X + 0x0000012C))
#define VMAC_TDMASTATE4(X)     (*(volatile unsigned int *)(X + 0x00000130))
#define VMAC_TDMASTATE5(X)     (*(volatile unsigned int *)(X + 0x00000134))
#define VMAC_TDMASTATE6(X)     (*(volatile unsigned int *)(X + 0x00000138))
#define VMAC_TDMASTATE7(X)     (*(volatile unsigned int *)(X + 0x0000013C))
#define VMAC_TXPADDCNT(X)      (*(volatile unsigned int *)(X + 0x00000140))
#define VMAC_TXPADDSTART(X)    (*(volatile unsigned int *)(X + 0x00000144))
#define VMAC_TXPADDEND(X)      (*(volatile unsigned int *)(X + 0x00000148))
#define VMAC_TXQFLUSH(X)       (*(volatile unsigned int *)(X + 0x0000014C))
 
#define VMAC_RCRPTR(X)         (*(volatile unsigned int *)(X + 0x00000200))
#define VMAC_RCRSIZE(X)        (*(volatile unsigned int *)(X + 0x00000204))
#define VMAC_RCRINTTHRESH(X)   (*(volatile unsigned int *)(X + 0x00000208))
#define VMAC_RCRTOTENT(X)      (*(volatile unsigned int *)(X + 0x0000020C))
#define VMAC_RCRFREEENT(X)     (*(volatile unsigned int *)(X + 0x00000210))
#define VMAC_RCRPENDENT(X)     (*(volatile unsigned int *)(X + 0x00000214))
#define VMAC_RCRENTINC(X)      (*(volatile unsigned int *)(X + 0x00000218))
#define VMAC_RXISRPACE(X)      (*(volatile unsigned int *)(X + 0x0000021c))

#define VMAC_RDMASTATE0(X)     (*(volatile unsigned int *)(X + 0x00000220))
#define VMAC_RDMASTATE1(X)     (*(volatile unsigned int *)(X + 0x00000224))
#define VMAC_RDMASTATE2(X)     (*(volatile unsigned int *)(X + 0x00000228))
#define VMAC_RDMASTATE3(X)     (*(volatile unsigned int *)(X + 0x0000022C))
#define VMAC_RDMASTATE4(X)     (*(volatile unsigned int *)(X + 0x00000230))
#define VMAC_RDMASTATE5(X)     (*(volatile unsigned int *)(X + 0x00000234))
#define VMAC_RDMASTATE6(X)     (*(volatile unsigned int *)(X + 0x00000238))
#define VMAC_RDMASTATE7(X)     (*(volatile unsigned int *)(X + 0x0000023C))
#define VMAC_FBLADDCNT(X)      (*(volatile unsigned int *)(X + 0x00000240))
#define VMAC_FBLADDSTART(X)    (*(volatile unsigned int *)(X + 0x00000244))
#define VMAC_FBLADDEND(X)      (*(volatile unsigned int *)(X + 0x00000248))
#define VMAC_RXONOFF(X)        (*(volatile unsigned int *)(X + 0x0000024C))
 
#define VMAC_FBL0NEXTD(X)      (*(volatile unsigned int *)(X + 0x00000280))
#define VMAC_FBL0LASTD(X)      (*(volatile unsigned int *)(X + 0x00000284))
#define VMAC_FBL0COUNTD(X)     (*(volatile unsigned int *)(X + 0x00000288))
#define VMAC_FBL0BUFSIZE(X)    (*(volatile unsigned int *)(X + 0x0000028C))
 
#define VMAC_MACCONTROL(X)     (*(volatile unsigned int *)(X + 0x00000300))
#define VMAC_MACSTATUS(X)      (*(volatile unsigned int *)(X + 0x00000304))
#define VMAC_MACADDRHI(X)      (*(volatile unsigned int *)(X + 0x00000308))
#define VMAC_MACADDRLO(X)      (*(volatile unsigned int *)(X + 0x0000030C))
#define VMAC_MACHASH1(X)       (*(volatile unsigned int *)(X + 0x00000310))
#define VMAC_MACHASH2(X)       (*(volatile unsigned int *)(X + 0x00000314))
 
#define VMAC_WRAPCLK(X)        (*(volatile unsigned int *)(X + 0x00000340))
#define VMAC_BOFTEST(X)        (*(volatile unsigned int *)(X + 0x00000344))
#define VMAC_PACTEST(X)        (*(volatile unsigned int *)(X + 0x00000348))
#define VMAC_PAUSEOP(X)        (*(volatile unsigned int *)(X + 0x0000034C))
 
#define VMAC_MDIOCONTROL(X)    (*(volatile unsigned int *)(X + 0x00000380))
#define VMAC_MDIOUSERACCESS(X) (*(volatile unsigned int *)(X +0x00000384))
#define VMAC_MDIOACK(X)        (*(volatile unsigned int *)(X + 0x00000388))
#define VMAC_MDIOLINK(X)       (*(volatile unsigned int *)(X + 0x0000038C))
#define VMAC_MDIOMACPHY(X)     (*(volatile unsigned int *)(X + 0x00000390))

#define VMAC_STATS_BASE(X)     (X + 0x00000400)

#endif __AVALANCHE_REGS_H






