/*******************************************************************************
 * FILE PURPOSE:    I2C Device Hardware Abstraction Layer Header
 *******************************************************************************
 * FILE NAME:       i2c_hal.h
 *
 * DESCRIPTION:     OS and platform independent I2C HAL module header file
 *
 * REVISION HISTORY:
 * 27 Nov 02 - PSP TII  
 *
 * (C) Copyright 2002, Texas Instruments, Inc
 ******************************************************************************/

#ifndef __I2C_HAL__
#define __I2C_HAL__

/*
 * HAL return values 
 */
 
#define I2C_HAL_OK                                    0
#define I2C_HAL_ERROR                                -1

/*
 * The device operating modes 
 */
#define I2C_HAL_MODE_POLL                            0
#define I2C_HAL_MODE_INTR                            1
 
/* HAL function prototypes */

/*******************************************************************************
*
* i2c_hal_init: initializes the HAL layer for the I2C module.
*
* This function initializes the I2C registers.
* It also initializes the HAL specific data structures.
* 
* The device registers are initialized here and the device
* is kept in quiscient state.
* After the init is called the read and write routines can
* be called. 
*
* RETURNS: returns I2C_HAL_OK on success and I2C_HAL_ERROR on failure.
* 
*******************************************************************************/
INT32 i2c_hal_init
(
    UINT32 base_addr,
    UINT32 operating_mode,
    UINT32 clock_rate,
    INT32 (*transmit_complete)(INT32)
);

/*******************************************************************************
*
* i2c_hal_write: writes to the specified device.
* 
* return values: returns I2C_HAL_OK on success and I2C_HAL_ERROR on failure.
*
*******************************************************************************/
INT32 i2c_hal_write
(   
    UINT8  addr,
    char   *p_buf,
    UINT32 length
);

/*******************************************************************************
*
* i2c_hal_read: reads the specific device for data.
* 
* RETURNS: returns I2C_HAL_OK on success and I2C_HAL_ERROR/I2C_HAL_DEVICE_BUSY
* on failure.
*
*******************************************************************************/
INT32 i2c_hal_read
(
    UINT8       addr,
    char*       p_buffer, 
    UINT32      length
);


/*******************************************************************************
*
* i2c_hal_isr: handles both read and write interrupts.
*
* return values: returns I2C_HAL_OK on success and I2C_HAL_ERROR on failure.
*
* *****************************************************************************/
INT32 i2c_hal_isr();

#endif /* __I2C_HAL__ */

