#ifndef _MIPS_SANGAM_H
#define _MIPS_SANGAM_H

#include <linux/config.h>
#include <asm/addrspace.h>


#ifndef LITTLE_ENDIAN
#define LITTLE_ENDIAN
#endif

#ifndef _LINK_KSEG0_
#define _LINK_KSEG0_
#endif

#include "haltypes.h"
#include "tnetd73xx.h"

/*
 * AR7 board SDRAM base address.  This is used to setup the
 * bootmem tables
 */

#define AVALANCHE_SDRAM_BASE 0x14000000UL
#define AVALANCHE_INTC_BASE  TNETD73XX_INTC_BASE


/*
 * AR7 board vectors
 */

#define AVALANCHE_VECS (KSEG1ADDR(AVALANCHE_SDRAM_BASE))
#define AVALANCHE_VECS_KSEG0 (KSEG0ADDR(AVALANCHE_SDRAM_BASE))


/*
 * Yamon Prom print address.
 */
#define AVALANCHE_YAMON_FUNCTION_BASE             (KSEG1ADDR(0x10000500))
#define AVALANCHE_YAMON_PROM_PRINT_COUNT_ADDR     (AVALANCHE_YAMON_FUNCTION_BASE + 0x4)  /* print_count function */
#define AVALANCHE_YAMON_PROM_PRINT_ADDR           (AVALANCHE_YAMON_FUNCTION_BASE + 0x34)

/*
 * AR7 Reset and PSU standby register.
 */
#define AVALANCHE_SOFTRES_REG         (KSEG1ADDR(0x08611600))    /* Resets machine */
#define AVALANCHE_PSUSTBY_REG         (KSEG1ADDR(0x08611600))    /* Turns off power supply unit */
#define AVALANCHE_GORESET             0x1
#define AVALANCHE_GOSTBY              0x1
#define AVALANCHE_SWRCR              (*(unsigned int *)TNETD73XX_RST_CTRL_SWRCR)

/*
 * Avalanche UART register base.
 */

#define AVALANCHE_UART0_REGS_BASE (KSEG1ADDR(0x08610E00)) /* AVALANCHE UART 0 */
#define AVALANCHE_UART1_REGS_BASE (KSEG1ADDR(0x08610F00)) /* AVALANCHE UART 1 */
#define AVALANCHE_BASE_BAUD       ( 3686400 / 16 )

/*
 * AVALANCHE DMA controller base
 */

#define AVALANCHE_DMA0_CTRL_BASE       (KSEG1ADDR(0x08611400)) /* DMA 0 (channels 0-3) */



/*
 * GPIO register map
 */

/* to be obtained from avalanche_map.h */
#define  AVALANCHE_GPIO_WRITE_REG         (KSEG1ADDR(0xa8610904))
#define  AVALANCHE_GPIO_DIRECTION_REG     (KSEG1ADDR(0xa8610908))
#define  AVALANCHE_GPIO_MODE_REG          (KSEG1ADDR(0xa861090C))
#define  AVALANCHE_GPIO_PIN_COUNT         32
#define  AVALANCHE_GPIO_OFF_MAP           {0xF34FFFC0,0}







extern unsigned int tnetd73xx_vbus_freq;
#define AVALANCHE_VBUS_FREQ            tnetd73xx_vbus_freq

static inline unsigned int get_avalanche_vbus_freq(void)
{
    return (tnetd73xx_vbus_freq);
}

#include "sangam_boards.h"
 
#endif /*_MIPS_AVALANCHE_H */
