/* 
 *  $Id: sar_bits.h,v 1.1.1.1 2003/06/23 22:18:41 jharrell Exp $
 *  Avalanche SAR Register bit Descriptions
 *
 *  Jeff Harrell, jharrell@ti.com
 *  2000 (c) Texas Instruments Inc.
 */

#ifndef __SAR_BITS_H
#define __SAR_BITS_H

/*----------------------------------------------------------*/
/* Avalanche System Config register bits (ATM_SAR_BASE + 0) */
/*----------------------------------------------------------*/
#define AV_ENABLE_PDSP     (1<<0)     // 1 = PDSP enabled
#define AV_PDSP_RESET      (1<<1)     // 1 = PDSP reset
#define AV_NNI_UNI         (1<<2)     // 1 = UNI mode 
#define AV_PERFORM_CRC     (1<<3)     // 1 = Perform CRC32 check (pdsp code d/l)
#define AV_OAM_F5          (1<<4)     // 1 = f5 level cells processed by host
#define AV_OAM_F4          (1<<5)     // 1 = f4 level cells processed by host
#define AV_AAL5_RX_EN      (1<<6)     // 1 = AAL5 reassembly engine enabled
#define AV_AAL5_TX_EN      (1<<7)     // 1 = AAL5 segmentation engine enabled
#define AV_AAL2_RX_EN_A    (1<<8)     // 1 = AAL2 reassembly engine enabled    (Rx fifo A)
#define AV_AAL2_TX_EN_A    (1<<9)     // 1 = AAL2 segmentation engine enabled  (Tx fifo A)
#define AV_AAL2_RX_EN_B    (1<<10)    // 1 = AAL2 reassembly engine enabled    (Rx fifo B)
#define AV_AAL2_TX_EN_B    (1<<11)    // 1 = AAL2 segmentation engine enabled  (Tx fifo B)
#define AV_AAL2_HOST       (1<<12)    // 1 = AAL2 packets fetched and forwarded to TX/RX fifos
#define AV_AAL2_SDU        (1<<13)    // 1 = AAL2 CPS-SDU max payload = 64 bytes (0=45 bytes)
#define AV_AAL2_HEC        (1<<14)    // 1 = AAL2 HEC will be calculated on all packets
#define AV_AAL2_MGMT       (1<<15)    // 1 = AAL2 module performs error indications to layer mgt.
#define AV_UTOPIA_TX_0     (1<<16)    // 1 = Enable UTOPIA Tx port 0
#define AV_UTOPIA_TX_1     (1<<17)    // 1 = Enable UTOPIA Tx port 1
#define AV_UTOPIA_TX_2     (1<<18)    // 1 = Enable UTOPIA Tx port 2
#define AV_TX_POLL_MODE    (1<<19)    // 1 = Enable static polling of TxPHY interfaces (0=UL2 polling)
#define AV_UTOPIA_RX_0     (1<<20)    // 1 = Enable UTOPIA Rx port 0
#define AV_UTOPIA_RX_1     (1<<21)    // 1 = Enable UTOPIA Rx port 1
#define AV_UTOPIA_RX_2     (1<<22)    // 1 = Enable UTOPIA Rx port 2
#define AV_RX_POLL_MODE    (1<<23)    // 1 = Enable static polling of RxPHY interfaces (0=UL2 polling)
#define AV_CELL_BUFF_EN    (1<<24)    // 1 = Cell buffer module enabled
/* bit 25 reserved */
#define AV_DSP_B_BYTE_SW   (1<<26)    // 1 = byte  swap on 32bit data from AAL2 DSP B fifos
#define AV_DSP_B_WORD_SW   (1<<27)    // 1 = word (16bit) swap on 32bit data from AAL2 DSP B fifos
#define AV_DSP_A_BYTE_SW   (1<<28)    // 1 = byte  swap on 32bit data from AAL2 DSP A fifos
#define AV_DSP_A_WORD_SW   (1<<29)    // 1 = word (16bit) swap on 32bit data from AAL2 DSP A fifos
#define AV_HOST_BYTE_SW    (1<<30)    // 1 = byte swap 32 bit data <-> AAL2 host fifos
#define AV_HOST_WORD_SW    (1<<31)    // 1 = word swap 32 bit data <-> AAL2 host fifos

/*------------------------------------------------------------------------*/
/* Avalanche System status register bits (ATM_SAR_BASE + 0x04)             */
/*------------------------------------------------------------------------*/
#define AV_STAT_AAL2_STAT     (1<<27)   // AAL2 Layer management status
#define AV_STAT_AAL2_TXB_FIFO (1<<26)   // AAL2 Error in host Tx FIFO (A)
#define AV_STAT_AAL2_TXA_FIFO (1<<25)   // AAL2 Error in host Tx FIFO (A)
#define AV_STAT_AAL2_TX_HOST  (1<<24)   // AAL2 Error in host Tx FIFO (B)
#define AV_STAT_AAL2_TX_UCH   (1<<23)   // AAL2 Tx unknown channel
#define AV_STAT_AAL2_TX_UDMA  (1<<22)   // AAL2 Tx unknown DMA
#define AV_STAT_AAL2_RX_OVF   (1<<21)   // AAL2 Rx overflow
#define AV_STAT_OAM_S2_PEND   (1<<17)   // OAM stat2 pending
#define AV_STAT_OAM_S1_PEND   (1<<16)   // OAM stat1 pending
#define AV_STAT_OAM_S0_PEND   (1<<15)   // OAM stat0 pending
#define AV_STAT_GPR1_PEND     (1<<14)   // General purpose reg 1 written by PDSP
#define AV_STAT_GPR0_PEND     (1<<13)   // General purpose reg 0 written by PDSP
#define AV_STAT_RX_FREEZE     (1<<11)   // Rx Freeze has occured
#define AV_STAT_RCR_INT_B     (1<<10)   // Rx Int B has occured
#define AV_STAT_RCR_POST_B    (1<<9)    // Rx completion ring B interrupt 
#define AV_STAT_RCR_INT_A     (1<<8)    // Rx Threshold completion ring interrupt A 
#define AV_STAT_RCR_POST_A    (1<<7)    // Rx completion ring A interrupt
#define AV_STAT_TX_FREEZE     (1<<6)    // Tx Freeze has occured
#define AV_STAT_TCR_INT_B     (1<<5)    // Tx Threshold completion ring interrupt B
#define AV_STAT_TCR_POST_B    (1<<4)    // Tx completion ring B interrupt
#define AV_STAT_TCR_INT_A     (1<<3)    // Tx Threshold completion ring interrupt A
#define AV_STAT_TCR_POST_A    (1<<2)    // Tx completion ring A interrupt
#define AV_STAT_CRC_CHECK     (1<<1)    // CRC check in progress (PDSP program memory)
#define AV_STAT_CRC_FAIL      (1<<0)    // CRC check passed

/*------------------------------------------------------------------------*/
/* Avalanche Interrupt enable register bits (ATM_SAR_BASE + 0x08)         */
/*------------------------------------------------------------------------*/
#define AV_AAL2_STATUS_INT     (1<<27)    // AAL2 status interrupt enable
#define AV_AAL2_TX_FIFO_INT_A  (1<<26)    // AAL2 Tx fifo interrupt enable
#define AV_AAL2_TX_FIFO_INT_B  (1<<25)    // AAL2 Tx fifo interrupt enable
#define AV_AAL2_TX_HOST_INT    (1<<24)    // AAL2 Tx host interrupt enable
#define AV_AAL2_TX_UNK_CH_INT  (1<<23)    // AAL2 Tx unknown channel interrupt 
#define AV_AAL2_TX_UNK_DMA_INT (1<<22)    // AAL2 Tx unknown dma channel interrupt
#define AV_AAL2_RX_OVERFLOW    (1<<21)    // AAL2 Rx overflow interrupt enable
#define AV_OAM_STAT2_PEND      (1<<17)    // OAM status pending interrupt (2)
#define AV_OAM_STAT1_PEND      (1<<16)    // OAM status pending interrupt (1)
#define AV_OAM_STAT0_PEND      (1<<15)    // OAM status pending interrupt (0)
#define AV_GPR1_PENDING        (1<<14)    // GRP pending interrupt (1)
#define AV_GPR0_PENDING        (1<<13)    // GRP pending interrupt (0)
#define AV_RX_FREEZE           (1<<11)    // Rx Freeze interrupt enabled
#define AV_RCR_INT_B           (1<<10)    // Rx Threshold interrupt B enable
#define AV_RCR_POST_B          (1<<9)     // Rx Completion ring interrupt B
#define AV_RCR_INT_A           (1<<8)     // Rx Threshold interrupt A enable
#define AV_RCR_POST_A          (1<<7)     // Rx completion ring interrupt A
#define AV_TX_FREEZE           (1<<6)     // Tx freeze interrupt
#define AV_TCR_INT_B           (1<<5)     // Tx Threshold interrupt B enable
#define AV_TCR_POST_B          (1<<4)     // Tx completion ring interrupt B
#define AV_TCR_INT_A           (1<<3)     // Tx Threshold interrupt A enable
#define AV_TCR_POST_A          (1<<2)     // Tx completion ring interrupt A
#define AV_CRC_FAIL            (1<<0)     // CRC failure interrupt

/*------------------------------------------------------------------------*/
/* Avalanche Connection Configuration register bits (ATM_SAR_BASE + 0x10) */
/*------------------------------------------------------------------------*/
#define AV_REASS_AAL5      (0<<25)  // Connection configured to reassemble AAL5 packets
#define AV_REASS_PTIN_AAL5 (1<<25)  // Connection configured to reassemble PTI NULL AAL packets
#define AV_OAM_PACKETS     (2<<25)  // OAM packets
#define AV_TRAN_PACKETS    (6<<25)  // Transparent packets
#define AV_AAL5_CONN       (0<<28)  // AAL5 Connection
#define AV_AAL2_CONN       (1<<28)  // AAL2 Connection
#define AV_VPI_VCI_CONN    (0<<29)  // Setup/teardown VPI/VCI connection
#define AV_VP_CROSS_CONN   (1<<29)  // Setup/teardown VC cross connect.
#define AV_SETUP_CHAN      (1<<30)  // Setup request of a DMA channel
#define AV_TEARDOWN_CHAN   (0<<30)  // Teardown request of a DMA channel
#define AV_SU_TD_READY     (1<<31)  // ok to setup/teardown a connection

/*------------------------------------------------------------------------*/
/* Avalanche OAM Configuration register bits (ATM_SAR_BASE + 0x18) */
/*------------------------------------------------------------------------*/
#define AV_OAM_ALARM_TYPE  (1<<29)  // Type = 0 State is AIS, Type = 1 State is RDI
#define AV_ALARM_CONFIG    (1<<30)  // Put connection in specified state = 1, Remove=0
#define AV_OAM_READY       (1<<31)  // Previous OAM configuration has been processed



/*------------------------------------------------------------------------*/
/* Avalanche Tx Flush  register bits (ATM_SAR_BASE + 0x14C) */
/*------------------------------------------------------------------------*/
#define AV_TX_FLUSH_READY  (1<<31)  // ok to flush Transmitter?


/*------------------------------------------*/
/* AVALANCHE SAR  state RAM bit definitions */
/*------------------------------------------*/

/* (Word 1) */
#define AV_QOS_CBR         0x0 //  Avalanche SAR QOS type
#define AV_QOS_UBR         0x1 //  
#define AV_QOS_VBR         0x2 //
//#define AV_QOS_VBRNRT      0x2 //
//#define AV_QOS_VBRRT       0x3 //

#define AV_CONN_TYPE_AAL5  0x0 // Avalanche SAR connection type 
#define AV_CONN_TYPE_AAL2  0x1 //
#define AV_CONN_TYPE_CROSS 0x2 //

#define AV_SRC_AAL5_AAL2   0x0 // Avalanche Source port 
#define AV_SRC_UTOPIA0     0x1 //
#define AV_SRC_UTOPIA1     0x2 //
#define AV_SRC_UTOPIA2     0x3 //
#define AV_SRC_ADSL0       0x4 //
#define AV_SRC_ADSL1       0x5 //

#define AV_DST_AAL5_AAL2   0x0 // Avalanche Destination port 
#define AV_DST_UTOPIA0     0x1 //
#define AV_DST_UTOPIA1     0x2 //
#define AV_DST_UTOPIA2     0x3 //
#define AV_DST_ADSL0       0x4 //
#define AV_DST_ADSL1       0x5 //

/* (Word 2) */
#define AV_QUEUEID_PA_Q0   0x0 // Queue id = port A, Queue 0  
#define AV_QUEUEID_PA_Q1   0x1 // Queue id = port A, Queue 1     
#define AV_QUEUEID_PA_Q2   0x2 // Queue id = port A, Queue 2
#define AV_QUEUEID_PA_Q3   0x2 // Queue id = port A, Queue 2
#define AV_QUEUEID_PB_Q0   0x0 // Queue id = port B, Queue 0 
#define AV_QUEUEID_PB_Q1   0x1 // Queue id = port B, Queue 1
#define AV_QUEUEID_PB_Q2   0x2 // Queue id = port B, Queue 2
#define AV_QUEUEID_PB_Q3   0x2 // Queue id = port B, Queue 2

/* (Word 3) */
/* CBR rates */

/* (Word 4) */
/* AAL2 receive states */

/*----------------------------------------*/
/* Tx DMA state RAM buffer                */
/*----------------------------------------*/
#define TX_COMP_SEL_A     (0<<23) // Select completion ring A
#define TX_COMP_SEL_B     (1<<23) // Select completion ring B
#define TX_BURST_SIZE     (0xC << 16) // Tx burst size


/*----------------------------------------*/
/* Tx data buffer (Word0/Word1) bits      */
/*----------------------------------------*/

#define AV_CLP_CELL_DISCARD    1;      /* Cell loss priority */
#define AV_AAL5_TYPE  0;
#define AV_NULL_TYPE  1;
#define AV_OAM_TYPE   2;
#define AV_TRANS_TYPE 3;

/*----------------------------------------*/
/* Tx Buffer descriptor BITS              */
/*----------------------------------------*/

/* ----Word 0-----*/
#define AV_TX_BUFFER_START  0x80000000   /* (1<<31) */
#define AV_TX_BUFFER_LAST   0x40000000   /* (1<<30) */
#define AV_TX_BUFFER_TCR_A  0x00000000   /* (0<<29) */
#define AV_TX_BUFFER_TCR_B  0x20000000   /* (1<<29) */

#define AV_TRAFTYPE_AAL5    0x00000000 /* (AV_AAL5_TYPE<<27) */
#define AV_TRAFTYPE_NULL    (AV_NULL_TYPE<<27)
#define AV_TRAFTYPE_OAM     (AV_OAM_TYPE<<27)
#define AV_TRAFTYPE_TRANSP  (AV_TRANS_TYPE<<27)


/*----------------------------------------*/
/* Tx Queue Packet Register bits          */
/*----------------------------------------*/
#define AV_QUEUE_PKT_RDY   0x80000000   /* (1<<31) */

/*----------------------------------------*/
/* Rx Completion Ring bits                */
/*----------------------------------------*/
#define AV_RX_BUFF_STARVE  0x0001       /* No Receive buffers available to SAR/QoS */
#define AV_RX_CRC_ERROR    0x0002       /* CRC error in the incoming packet        */
#define AV_RX_PKT_OVFL     0x0004       /* Rx packet exceeded 1366 ATM cells       */
#define AV_RX_AAL5_ABORT   0x0008       /* Rx AAL5 length field was 0x0            */
#define AV_RX_TEARDOWN     0x0080       /* Channel was torn down                   */

/*----------------------------------------*/
/* Rx FBL bits                            */
/*----------------------------------------*/
#define AV_RX_FBL_ADD_RDY 0x80000000


/*----------------------------------------*/
/* SAR IOCTL commands                     */
/*----------------------------------------*/
#include <linux/ioctl.h>

#define SAR_DSL_RESET_SOFTBOOT  _IO('a', 0x80 )

#endif __SAR_BITS_H




