/***************************************************************************
**+----------------------------------------------------------------------+**
**|                                ****                                  |**
**|                                ****                                  |**
**|                                ******o***                            |**
**|                          ********_///_****                           |**
**|                           ***** /_//_/ ****                          |**
**|                            ** ** (__/ ****                           |**
**|                                *********                             |**
**|                                 ****                                 |**
**|                                  ***                                 |**
**|                                                                      |**
**|     Copyright (c) 1998,1999,2003 Texas Instruments Incorporated      |**
**|                        ALL RIGHTS RESERVED                           |**
**|                                                                      |**
**| Permission is hereby granted to licensees of Texas Instruments       |**
**| Incorporated (TI) products to use this computer program for the sole |**
**| purpose of implementing a licensee product based on TI products.     |**
**| No other rights to reproduce, use, or disseminate this computer      |**
**| program, whether in part or in whole, are granted.                   |**
**|                                                                      |**
**| TI makes no representation or warranties with respect to the         |**
**| performance of this computer program, and specifically disclaims     |**
**| any responsibility for any damages, special or consequential,        |**
**| connected with the use of this program.                              |**
**|                                                                      |**
**+----------------------------------------------------------------------+**
***************************************************************************/

/****************************************************************************/
/*																		                                    	*/
/*		MODULE:	tiwlan_drv.h										                             	*/
/*		PURPOSE: Kernel mode portion of WLAN AP user mode driver header.	    */
/*    CREATOR: Alexander Sirotkin                                           */
/*             demiurg@ti.com                                               */
/*																		                                     	*/
/****************************************************************************/

#ifndef TIWLAN_DRV_INCLUDE_FILE
#define TIWLAN_DRV_INCLUDE_FILE


#define TIWLAN_DRV_MAJOR 42 // TODO change to 242
#define TIWLAN_DRV_NAME "tiwlan_drv"
#define TIWLAN_DRV_IF_NAME "tiwlan0"
#define TIWLAN_DRV_DEVNAME "/dev/tiwlan"

//#define TIWLAN_CM_SOCKET_PATH "/var/tmp/ap.ctl"
#define TIWLAN_CM_SOCKET_PATH "/var/tmp/cm_logic.ctl"
#define TIWLAN_PTY_NAME_PATH "/var/tmp/tiwlan.cli.pty.name.txt"

#define TIWLAN_DRV_NAME_WIRELESS_PROTO "IEEE 802.11-DS"

#define TIWLAN_DRV_IOCTL_MAGIC 'w'
#define TIWLAN_DRV_HEADER_EXTRA_LENGTH   256

// TODO : where the heck should I place this ?
#define MAC_ADDR_LEN 6

typedef enum {
	TIWLAN_IOCTL_DATA_U8,
	TIWLAN_IOCTL_DATA_U16,
	TIWLAN_IOCTL_DATA_U32,
	TIWLAN_IOCTL_DATA_CHAR_PTR,
	TIWLAN_IOCTL_DATA_MEM_BASE,
	TIWLAN_IOCTL_DATA_NONE,
	TIWLAN_IOCTL_DATA_PACKET,
	TIWLAN_IOCTL_DATA_WEP_KEYS
} tiwlan_ioctl_data_t;

#define TIWLAN_MAX_WEP_KEY_LEN 30


typedef struct {
	UINT16 index;
	UINT8 len;
	UINT8 value[TIWLAN_MAX_WEP_KEY_LEN];
} tiwlan_ioctl_wep_keys_t;

#define TIWLAN_IOCTL_DATA_SIZE 64

typedef enum {
	TIWLAN_CMD_GET_MAC_ADDR,
	TIWLAN_CMD_GET_MAC_ADDR_RES,
	TIWLAN_CMD_SET_MAC_ADDR,

	TIWLAN_CMD_GET_SSID,
	TIWLAN_CMD_GET_SSID_RES,
	TIWLAN_CMD_SET_SSID,

	TIWLAN_CMD_GET_CHANNEL,
	TIWLAN_CMD_GET_CHANNEL_RES,
	TIWLAN_CMD_SET_CHANNEL,

	TIWLAN_CMD_GET_FRAG,
	TIWLAN_CMD_GET_FRAG_RES,
	TIWLAN_CMD_SET_FRAG,

	TIWLAN_CMD_GET_RETRY,
	TIWLAN_CMD_GET_RETRY_RES,
	TIWLAN_CMD_SET_RETRY,

	TIWLAN_CMD_GET_RTS,
	TIWLAN_CMD_GET_RTS_RES,
	TIWLAN_CMD_SET_RTS,

	TIWLAN_CMD_IOCTL_SET_PREAMBLE,
	TIWLAN_CMD_SET_PREAMBLE,
	TIWLAN_CMD_GET_PREAMBLE_RES,
	TIWLAN_CMD_IOCTL_GET_PREAMBLE,
	TIWLAN_CMD_GET_PREAMBLE,

	TIWLAN_CMD_IOCTL_SET_PBCC,
	TIWLAN_CMD_SET_PBCC,
	TIWLAN_CMD_GET_PBCC_RES,
	TIWLAN_CMD_IOCTL_GET_PBCC,
	TIWLAN_CMD_GET_PBCC,

	TIWLAN_CMD_IOCTL_SET_BEACON_PERIOD,
	TIWLAN_CMD_SET_BEACON_PERIOD,
	TIWLAN_CMD_GET_BEACON_PERIOD_RES,
	TIWLAN_CMD_IOCTL_GET_BEACON_PERIOD,
	TIWLAN_CMD_GET_BEACON_PERIOD,

	TIWLAN_CMD_IOCTL_SET_DTIM_PERIOD,
	TIWLAN_CMD_SET_DTIM_PERIOD,
	TIWLAN_CMD_GET_DTIM_PERIOD_RES,
	TIWLAN_CMD_IOCTL_GET_DTIM_PERIOD,
	TIWLAN_CMD_GET_DTIM_PERIOD,

	TIWLAN_CMD_IOCTL_SET_WEP_KEYS,
	TIWLAN_CMD_SET_WEP_KEYS,
	TIWLAN_CMD_GET_WEP_KEYS_RES,
	TIWLAN_CMD_IOCTL_GET_WEP_KEYS,
	TIWLAN_CMD_GET_WEP_KEYS,

	TIWLAN_CMD_IOCTL_SET_WEP_KEY_ID,
	TIWLAN_CMD_SET_WEP_KEY_ID,
	TIWLAN_CMD_GET_WEP_KEY_ID_RES,
	TIWLAN_CMD_IOCTL_GET_WEP_KEY_ID,
	TIWLAN_CMD_GET_WEP_KEY_ID,

	TIWLAN_CMD_IOCTL_SET_MAX_BASIC_RATE,
	TIWLAN_CMD_SET_MAX_BASIC_RATE,
	TIWLAN_CMD_GET_MAX_BASIC_RATE_RES,
	TIWLAN_CMD_IOCTL_GET_MAX_BASIC_RATE,
	TIWLAN_CMD_GET_MAX_BASIC_RATE,

	TIWLAN_CMD_IOCTL_SET_MAX_SUPP_RATE,
	TIWLAN_CMD_SET_MAX_SUPP_RATE,
	TIWLAN_CMD_GET_MAX_SUPP_RATE_RES,
	TIWLAN_CMD_IOCTL_GET_MAX_SUPP_RATE,
	TIWLAN_CMD_GET_MAX_SUPP_RATE,

	TIWLAN_CMD_IOCTL_SET_AUTH_TYPE,
	TIWLAN_CMD_SET_AUTH_TYPE,
	TIWLAN_CMD_GET_AUTH_TYPE_RES,
	TIWLAN_CMD_IOCTL_GET_AUTH_TYPE,
	TIWLAN_CMD_GET_AUTH_TYPE,

	TIWLAN_CMD_SET_RES,
	TIWLAN_CMD_GET_ISR,
	TIWLAN_CMD_SET_PACKET,
	TIWLAN_CMD_GET_PACKET,

	TIWLAN_CMD_SET_USER_READY,
	TIWLAN_CMD_GET_MEM_BASE,

	TIWLAN_CMD_IOCTL_SET_LOAD_CONF,
	TIWLAN_CMD_SET_LOAD_CONF,
	TIWLAN_CMD_GET_SAVE_CONF_RES,
	TIWLAN_CMD_IOCTL_GET_SAVE_CONF,
	TIWLAN_CMD_GET_SAVE_CONF
} tiwlan_ioctl_cmd_opcode_t;

#define TIWLAN_CONF_BUF_SIZE 2053

#define TIWLAN_IOCTL_CMD_SIZE sizeof(tiwlan_ioctl_cmd_t)

#define TIWLAN_DRV_IOCTL_IOCTL _IOWR(TIWLAN_DRV_IOCTL_MAGIC, 0, tiwlan_ioctl_cmd_t)


typedef struct _tiwlan_ioctl_cmd {
	tiwlan_ioctl_cmd_opcode_t opcode;
	UINT32 data_size;
	tiwlan_ioctl_data_t data_type;
	char data[TIWLAN_IOCTL_DATA_SIZE];
	char * packet;
} tiwlan_ioctl_cmd_t;

typedef struct {
 UINT32 mem, reg, mem_size, reg_size;
} tiwlan_mem_base_t;

#ifdef __KERNEL__

#include <linux/ioctl.h>

#define TIWLAN_DO_IOCTL_TIMEOUT 100
#define	VENDOR_ID_TI		0x104c
#define DEVICE_ID_TI_WLAN	0x8400

typedef struct {
	int magic;
} tiwlan_net_dev_priv_t;

typedef enum {
	TIWLAN_MSG_ERROR,
	TIWLAN_MSG_ERESTARTSYS,
	TIWLAN_MSG_MEM_BASE,
	TIWLAN_MSG_IOCTL,
	TIWLAN_MSG_ISR,
	TIWLAN_MSG_PACKET
}	tiwlan_msg_type_t;


typedef struct {
	tiwlan_msg_type_t msg;	
	struct list_head list;
	char * data;
} tiwlan_msg_entry_t;

typedef struct {
	spinlock_t lock;
	//	struct semaphore sem;
	wait_queue_head_t wait_queue;
	struct list_head head;
	struct list_head * first, * last;
	int size, count;
#ifdef TIWLAN_DEBUG_MSG_QUEUE
	atomic_t test;
#endif
} tiwlan_msg_queue_t;

typedef struct {
	struct sk_buff * skb;
	struct list_head head;
}  tiwlan_xmit_queue_t;

#else

#define TIWLAN_MAX_FILE_NAME 128
#define TIWLAN_CLI_SOCKET_PATH "/var/tmp/cli.fd"
#define TIWLAN_FWVERSION_FILE "/var/tmp/wlan.firmware.version.txt"

#ifndef ti_dprintf
#define ti_dprintf(level, msg) do { \
printf msg; \
} while (0)
#endif // ti_dprintf

void wapp_utilsPrintf(unsigned long level, int priority,
											const char *format, ...);

int wlanNVRAMReadCB(unsigned char * pbSrc, unsigned short wLen);
int wlanNVRAMWriteCB(unsigned char * pbSrc, unsigned short wLen);

#endif // __KERNEL__

#endif // TIWLAN_DRV_INCLUDE_FILE
