/*************************************************
 *     vmac_bits.h
 *     Host Register Contents
 *
 *************************************************/

#ifndef __VMAC_BITS_H
#define __VMAC_BITS_H

/*----------------------------------------------------------*/
/* DMACONFIG register bits (ETH_MACA_BASE + 0x00) */
/*----------------------------------------------------------*/
#define SRESET             (1<<31)    // 1 = Soft Reset DMA State Machine & MAC
#define RX_ENABLE          (1<<1)     // 1 = Rx DMA State Machine Enable
#define TX_ENABLE          (1<<0)     // 1 = Tx DMA State Machine Enable


/* INTSTS @ 0x04 */
#define LINK_CHANGE (1<<9)
#define LNKEVT      (1<<8)
#define CPLEVT      (1<<7)
#define ACKEVT      (1<<6)
#define RCR_FREEZE  (1<<5)
#define RCRA_THRESH (1<<4)
#define POSTED_RCRA (1<<3)
#define TCR_FREEZE  (1<<2)
#define TCRA_THRESH (1<<1)
#define POSTED_TCRA (1<<0)

/* TCRENTINC @ 0x118 */
#define TCR_RDY     (1<<31)


/* TXPADDCNT @ 0x140 */
#define TPK_RDY     (1<<31)

/* TXQFLUSH @ 0x14c */
#define TFL_RDY     (1<<31)

/* RCRENTINC @ 0X218 */
#define RCR_RDY     (1<<31)

/* FBLADDCNT @ 0x240 */
#define FBL_RDY     (1<<31)

/*  RXONOFF 0x24c */
#define RX_RDY      (1<<31)
#define ON_OFF      (1<<30)

/* MACCONTROL 0x300 */
#define DISABLE     (1<<31)
#define TXHOLD      (1<<30)
#define CLRP        (1<<29)
#define FFC         (1<<28)
#define NO_LOOP     (1<<27)
#define MTEST       (1<<26)
/*                  Bits 20-25      RESERVED            */
#define PEFCE       (1<<19)
#define NO_BRX      (1<<18)
#define FLOW_EN     (1<<17)
#define MAXLEN      (1<<16)
#define LONG        (1<<15)
#define PASS_CRC    (1<<14)
#define CMF         (1<<13)
#define CSF         (1<<12)
#define CEF         (1<<11)
#define CAF         (1<<10)
#define NO_CHAIN    (1<<9)
#define TXPACE      (1<<8)
/*                  Bits 3-7        RESERVED            */
#define PAUSE       (1<<2)
#define SPEED_100   (1<<1)
#define FULL_DUPLEX (1<<0)


/*----------------------------------------------------------*/
/* MDIOCONTROL register bits (ETH_MACA_BASE + 0x380) */
/*----------------------------------------------------------*/
#define IDLE             (1<<31)    // 1 = MDIO SM is IDLE
#define MDIO_ENABLE      (1<<30)    // 1 = Enable control
#define SHARED           (1<<29)    // 1 = Share control
/*                       Bits 27-28    MDIOOID             */
/*                       Bits 21-26    RESERVED            */
#define PREAMBLE         (1<<20)    // 1 = Preamble disable
#define FAULT            (1<<19)    // 1 = Fault indicator
/*                       Bits 16-18    RESERVED            */
#define RESUME             (1<<15)  // 1 = Resume control
/*                       Bits 8-14     RESERVED            */
/*                       Bits 0-7      CLKDIV              */

/*----------------------------------------------------------*/
/* MDIOUSERACCESS register bits (ETH_MACA_BASE + 0x384) */
/*----------------------------------------------------------*/
#define GO               (1<<31)    // 1 = GO, MDIO access attempt
#define MDIOWRITE        (1<<30)    // 1 = causes MDIO register write
#define ACK              (1<<29)    // (RO) 1 = Phy acknowleged transfer
/*                       Bits 26-28    RESERVED             */
/*                       Bits 21-25    PHY register address */
/*                       Bits 16-20    PHY to be accessed   */
/*                       Bits 0-15     PHY data             */

/*----------------------------------------------------------*/
/* MDIOMACPHY register bits (ETH_MACA_BASE + 0x390) */
/*----------------------------------------------------------*/
#define LN               (1<<7)     // 1 = Enable MDIO Link Determination
/*                       Bits 6-5    RESERVED             */
/*                       Bits 0-4    PHY register address */


struct vmac_stat_regs /* Avalanche VMAC statistics Registers */
{
  volatile unsigned long  rx_octets;
  volatile unsigned long  good_rx_frames;
  volatile unsigned long  broadcast_rx_frames;
  volatile unsigned long  multicast_rx_frames;
  volatile unsigned long  rx_crc_errors;
  volatile unsigned long  rx_align_code_errors;
  volatile unsigned long  oversized_rx_frames;
  volatile unsigned long  rx_jabbers;
  volatile unsigned long  undersized_rx_frames;
  volatile unsigned long  rx_fragments;
  volatile unsigned long  frames_64octet;
  volatile unsigned long  frames_65_127octet;
  volatile unsigned long  frames_128_255octet;
  volatile unsigned long  frames_256_511octet;
  volatile unsigned long  frames_512_1023octet;
  volatile unsigned long  frames_1024_1518octet;
  volatile unsigned long  net_octets;
  volatile unsigned long  sqe_test_errors;
  volatile unsigned long  tx_octets;
  volatile unsigned long  good_tx_frames;
  volatile unsigned long  single_col_tx_frames;
  volatile unsigned long  mul_col_tx_frames;
  volatile unsigned long  carrier_sense_errors;
  volatile unsigned long  deferred_tx_frames;
  volatile unsigned long  late_collisions;
  volatile unsigned long  excessive_collisions;
  volatile unsigned long  broadcast_tx_frames;
  volatile unsigned long  multicast_tx_frames;
  volatile unsigned long  filtered_rx_frames;
  volatile unsigned long  tx_error_frames;
  volatile unsigned long  collisions;
  volatile unsigned long  rx_overruns;
  volatile unsigned long  pause_tx_frames;
  volatile unsigned long  pause_rx_frames; 
};    

#endif __VMAC_BITS_H
