#############################################################
#
# linux-atm
#
#############################################################
LINUXATM_VERSION:=2.4.1
LINUXATM_SOURCE:=linux-atm-$(LINUXATM_VERSION).tar.gz
LINUXATM_SITE:=http://unc.dl.sourceforge.net/sourcefourge/linux-atm
LINUXATM_DIR:=$(BUILD_DIR)/linux-atm-$(LINUXATM_VERSION)

$(DL_DIR)/$(LINUXATM_SOURCE):
	$(WGET) -P $(DL_DIR) $(LINUXATM_SITE)/$(LINUXATM_SOURCE)

$(LINUXATM_DIR)/.source: $(DL_DIR)/$(LINUXATM_SOURCE)
	zcat $(DL_DIR)/$(LINUXATM_SOURCE) | tar -C $(BUILD_DIR) $(TAR_OPTIONS) -
	touch $(LINUXATM_DIR)/.source

$(LINUXATM_DIR)/.configured: $(LINUXATM_DIR)/.source
	(cd $(LINUXATM_DIR); \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		LDFLAGS="-L$(TARGET_DIR)/usr/lib" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--sysconfdir=/etc \
	);
	touch $(LINUXATM_DIR)/.configured;

$(LINUXATM_DIR)/.built: $(LINUXATM_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(LINUXATM_DIR)

#$(TARGET_DIR)/$(LINUXATM_TARGET_BINARY): $(LINUXATM_DIR)/$(LINUXATM_BINARY)
#	$(MAKE) prefix=$(TARGET_DIR)/usr -C $(LINUXATM_DIR) install
#	rm -Rf $(TARGET_DIR)/usr/man

#linux-atm: uclibc $(TARGET_DIR)/$(LINUXATM_TARGET_BINARY)
linux-atm: uclibc flex $(LINUXATM_DIR)/.built

linux-atm-source: $(DL_DIR)/$(LINUXATM_SOURCE)

linux-atm-clean:
	#$(MAKE) prefix=$(TARGET_DIR)/usr -C $(LINUXATM_DIR) uninstall
	-$(MAKE) -C $(LINUXATM_DIR) clean

linux-atm-dirclean:
	rm -rf $(LINUXATM_DIR)

