#############################################################
#
# mksquashfs to build target squashfs filesystems
#
#############################################################
SQUASHFS2_DIR=$(BUILD_DIR)/squashfs2.0r2
SQUASHFS2_SOURCE=squashfs2.0-r2.tar.gz
SQUASHFS2_SITE=http://aleron.dl.sourceforge.net/sourceforge/squashfs

FBOXFW_DIR=$(BUILD_DIR)/fboxfw-03.29
FBOXFW_SOURCE=fritz.box_fon_wlan.08.03.29.image
FBOXFW_SITE=ftp://ftp.avm.de/cardware/fritzbox.fon_wlan/firmware

$(DL_DIR)/$(SQUASHFS2_SOURCE):
	$(WGET) -P $(DL_DIR) $(SQUASHFS2_SITE)/$(SQUASHFS2_SOURCE)
$(DL_DIR)/$(FBOXFW_SOURCE):
	$(WGET) --passive-ftp -P $(DL_DIR) $(FBOXFW_SITE)/$(FBOXFW_SOURCE)

$(SQUASHFS2_DIR)/.source: $(DL_DIR)/$(SQUASHFS2_SOURCE) #$(SQUASHFS2_PATCH)
	zcat $(DL_DIR)/$(SQUASHFS2_SOURCE) | tar -C $(BUILD_DIR) -xvf -
	#toolchain/patch-kernel.sh $(SQUASHFS2_DIR) target/fritz/ squashfs.patch
	touch $@

$(FBOXFW_DIR)/.unpacked: $(DL_DIR)/$(FBOXFW_SOURCE)
	-mkdir -p $(FBOXFW_DIR)/root-fs
	-chmod -R u+w $(FBOXFW_DIR)/root-fs
	-rm -rf $(FBOXFW_DIR)/root-fs/*
	tar -C $(FBOXFW_DIR) -xvf $(DL_DIR)/$(FBOXFW_SOURCE)
	#-mkdir $(BUILD_DIR)/fboxmnt
	#sudo mount -o loop -t squashfs $(FBOXFW_DIR)/var/tmp/filesystem.image $(BUILD_DIR)/fboxmnt
	#cp -a $(BUILD_DIR)/fboxmnt/* $(FBOXFW_DIR)/root-fs
	#sudo umount $(BUILD_DIR)/fboxmnt
	#rmdir $(BUILD_DIR)/fboxmnt
	target/fritz/dumpsquashfs -x -f $(FBOXFW_DIR)/var/tmp/filesystem.image\
	  -C $(FBOXFW_DIR)/root-fs
	touch $@

$(SQUASHFS2_DIR)/squashfs-tools/mksquashfs: $(SQUASHFS2_DIR)/.source
	$(MAKE) -C $(SQUASHFS2_DIR)/squashfs-tools;

squashfs2: $(SQUASHFS2_DIR)/squashfs-tools/mksquashfs

squashfs2-source: $(DL_DIR)/$(SQUASHFS2_SOURCE)

squashfs2-clean:
	-$(MAKE) -C $(SQUASHFS2_DIR)/squashfs-tools clean

squashfs2-dirclean:
	rm -rf $(SQUASHFS2_DIR)

fboxfw: $(FBOXFW_DIR)/.unpacked

fboxfw-source: $(DL_DIR)/$(FBOXFW_SOURCE)

fboxfw-dirclean:
	rm -rf $(FBOXFW_DIR)

#############################################################
#
# Build the fritzbox root filesystem image
#
#############################################################

fritzboximage: $(SQUASHFS2_DIR)/squashfs-tools/mksquashfs fritzboximage-source
	rm -rf $(BUILD_DIR)/tmproot
	mkdir $(BUILD_DIR)/tmproot
	cp -a $(FBOXFW_DIR)/root-fs/* $(BUILD_DIR)/tmproot
	# remove original busybox
	find $(BUILD_DIR)/tmproot -ls | \
	  awk '/busybox/ {print $$11}' | xargs rm
	tar cf - -C $(TARGET_DIR) ./lib | tar xvf - -C $(BUILD_DIR)/tmproot
	tar cf - -C  $(TARGET_DIR) \
	  $$(cd $(TARGET_DIR) ; find . -ls | awk '/busybox/ {print $$11}') | \
	  tar xvf - -C $(BUILD_DIR)/tmproot
	( cd $(BUILD_DIR)/tmproot/lib && \
	  rm -f libncurses.so* libthread_db* *0.9.26*)
	rm -f $(BUILD_DIR)/tmproot/etc/inittab
	( echo "::restart:/sbin/init"; \
	  echo; \
	  cat $(FBOXFW_DIR)/root-fs/etc/inittab ) \
	  >> $(BUILD_DIR)/tmproot/etc/inittab
	#cp ./target/fritz/rc.nfs $(BUILD_DIR)/tmproot/etc/init.d && \
	#  chmod 755 $(BUILD_DIR)/tmproot/etc/init.d/rc.nfs
	#tar xjvf ./target/fritz/nfs-modules-2.4.17.tar.bz2 \
	#  -C $(BUILD_DIR)/tmproot/lib/modules/2.4.17_mvl21-malta-mips_fp_le/kernel/drivers/net
	# need more room ...
	#for i in 1und1 aol arcor avme freenet ; do rm -rf $(BUILD_DIR)/tmproot/usr/www/$$i && ln -s /usr/www/avm $(BUILD_DIR)/tmproot/usr/www/$$i; done
	#-find $(BUILD_DIR)/tmproot -type f -perm +111 | \
	#  xargs $(STRIP) 2>/dev/null
	$(SQUASHFS2_DIR)/squashfs-tools/mksquashfs $(BUILD_DIR)/tmproot \
	  filesystem.image -noappend -root-owned
	chmod -R u+w $(BUILD_DIR)/tmproot
	#rm -rf $(BUILD_DIR)/tmproot

fritzboximage-source: fboxfw

fritzboximage-clean:
	-$(MAKE) -C $(SQUASHFS2_DIR) clean

fritzboximage-dirclean:
	rm -rf $(SQUASHFS2_DIR)

