#############################################################
#
# mksquashfs to build target squashfs filesystems
#
#############################################################
SQUASHFS2_DIR=$(BUILD_DIR)/squashfs2.0r2
SQUASHFS2_SOURCE=squashfs2.0-r2.tar.gz
SQUASHFS2_SITE=http://aleron.dl.sourceforge.net/sourceforge/squashfs

FBOXFW_DIR=$(BUILD_DIR)/fboxfw
FBOXFW_SOURCE2=fritz.box_fon_wlan.08.03.29.image
FBOXFW_SOURCE=fritz.box_fon_ata.11.03.30.image
FBOXFW_SITE2=ftp://ftp.avm.de/cardware/fritzbox.fon_wlan/firmware
FBOXFW_SITE=ftp://ftp.avm.de/cardware/fritz!box.fon_ata/firmware

$(DL_DIR)/$(SQUASHFS2_SOURCE):
	$(WGET) -P $(DL_DIR) $(SQUASHFS2_SITE)/$(SQUASHFS2_SOURCE)
$(DL_DIR)/$(FBOXFW_SOURCE):
	$(WGET) --passive-ftp -P $(DL_DIR) $(FBOXFW_SITE)/$(FBOXFW_SOURCE)
	$(WGET) --passive-ftp -P $(DL_DIR) $(FBOXFW_SITE2)/$(FBOXFW_SOURCE2)

$(SQUASHFS2_DIR)/.source: $(DL_DIR)/$(SQUASHFS2_SOURCE) #$(SQUASHFS2_PATCH)
	zcat $(DL_DIR)/$(SQUASHFS2_SOURCE) | tar -C $(BUILD_DIR) -xvf -
	#toolchain/patch-kernel.sh $(SQUASHFS2_DIR) target/fritz/ squashfs.patch
	touch $@

$(FBOXFW_DIR)/.unpacked: $(DL_DIR)/$(FBOXFW_SOURCE)
	-mkdir -p $(FBOXFW_DIR)/root-fs
	-chmod -R u+w $(FBOXFW_DIR)/root-fs
	-rm -rf $(FBOXFW_DIR)/root-fs/*
	tar -C $(FBOXFW_DIR) -xf $(DL_DIR)/$(FBOXFW_SOURCE2) \
	  ./var/tmp/filesystem.image 
	mv $(FBOXFW_DIR)/var/tmp/filesystem.image \
	  $(FBOXFW_DIR)/var/tmp/filesystem.image.29
	target/fritz/dumpsquashfs -xf $(FBOXFW_DIR)/var/tmp/filesystem.image.29\
	  -C $(FBOXFW_DIR)/root-fs
	tar -C $(FBOXFW_DIR) -xf $(DL_DIR)/$(FBOXFW_SOURCE)
	target/fritz/dumpsquashfs -xuf $(FBOXFW_DIR)/var/tmp/filesystem.image\
	  -C $(FBOXFW_DIR)/root-fs
	target/fritz/dumpsquashfs -xf $(FBOXFW_DIR)/var/tmp/kernel.image\
	  -C $(FBOXFW_DIR)/root-fs/lib/modules/2.4.17_mvl21-malta-mips_fp_le/kernel/hidden
	touch $@

$(SQUASHFS2_DIR)/squashfs-tools/mksquashfs: $(SQUASHFS2_DIR)/.source
	$(MAKE) -C $(SQUASHFS2_DIR)/squashfs-tools;

squashfs2: $(SQUASHFS2_DIR)/squashfs-tools/mksquashfs

squashfs2-source: $(DL_DIR)/$(SQUASHFS2_SOURCE)

squashfs2-clean:
	-$(MAKE) -C $(SQUASHFS2_DIR)/squashfs-tools clean

squashfs2-dirclean:
	rm -rf $(SQUASHFS2_DIR)

fboxfw: $(FBOXFW_DIR)/.unpacked

fboxfw-source: $(DL_DIR)/$(FBOXFW_SOURCE)

fboxfw-dirclean:
	rm -rf $(FBOXFW_DIR)

#############################################################
#
# Build the fritzbox root filesystem image
#
#############################################################

mtd0.img mtd1.img: $(SQUASHFS2_DIR)/squashfs-tools/mksquashfs \
  $(FBOXFW_DIR)/.unpacked $(LINUX_DIR)/ram_zimage_pad.bin
	rm -rf $(BUILD_DIR)/tmproot
	mkdir $(BUILD_DIR)/tmproot
	cp -a $(FBOXFW_DIR)/root-fs/* $(BUILD_DIR)/tmproot
	# remove original busybox
	find $(BUILD_DIR)/tmproot -ls | \
	  awk '/busybox/ {print $$11}' | xargs rm
	tar cf - -C $(TARGET_DIR) ./lib | tar xvf - -C $(BUILD_DIR)/tmproot
	tar cf - -C $(TARGET_DIR) \
	  $$(cd $(TARGET_DIR) ; find . -ls | awk '/busybox/ {print $$11}') | \
	  tar xvf - -C $(BUILD_DIR)/tmproot
	# make room (more room: /etc/*.default/<provider> etc.)
	( cd $(BUILD_DIR)/tmproot/lib && \
	  rm -f libncurses.so* libthread_db* modules/cdrom.iso \
	  modules/minivoip_top.bit modules/ubik/boot-ubik2-sport.lod; \
	  if [ -f libuClibc-0.9.27.so ] ; then \
	    rm -rf *0.9.26*; \
	  fi )
	( cd $(BUILD_DIR)/tmproot/usr/www && \
	  for dir in 1und1 aol arcor avme freenet; do \
	    rm -rf $$dir && ln -s avm $$dir ; done )
	# as long as I don't have a prototype, we don't need these
	( cd $(BUILD_DIR)/tmproot && \
	  for dir in /etc/default.Fritz_Box_Eumex300IP \
	             /etc/default.Fritz_Box_FON_2 \
		     /etc/default.Fritz_Box_FON_2_WLAN \
		     /etc/default.Fritz_Box_MVoIP; do rm -rf ./$$dir ; done )
	( cd $(BUILD_DIR)/tmproot && \
	  for file in /etc/Fritz_Box_Eumex300IP.led.conf \
	              /etc/Fritz_Box_FON_2.led.conf \
		      /etc/Fritz_Box_FON_2_WLAN.led.conf \
		      /etc/Fritz_Box_MVoIP.led.conf; do rm -f ./$$file ; done )
	# allow a user cgi
	( cd $(BUILD_DIR)/tmproot/usr/www/avm/cgi-bin && \
	  ln -s /var/tmp/test.cgi . )
	toolchain/patch-kernel.sh $(BUILD_DIR)/tmproot target/fritz/patches
	$(SQUASHFS2_DIR)/squashfs-tools/mksquashfs $(BUILD_DIR)/tmproot \
	  filesystem.image -noappend -root-owned
	chmod -R u+w $(BUILD_DIR)/tmproot
	rm -rf $(BUILD_DIR)/tmproot
	cat $(LINUX_DIR)/ram_zimage_pad.bin filesystem.image > img.tmp
	rm -f filesystem.image
	dd if=img.tmp of=mtd1.img bs=1024 count=704
	dd if=img.tmp of=mtd0.img bs=1024 skip=704
	rm -f img.tmp

fritzboximage: mtd0.img mtd1.img

fritzboximage-clean:
	rm -f mtd0.img mtd1.img

