#############################################################
#
# AVM GPL Sources for the Fritz!Box
#
#############################################################
AVM_GPL_SOURCE:=gpl-source-files-03.22-ar7bin-build_664-359m.tar.gz
AVM_GPL_SITE:=ftp://ftp.avm.de/develper/opensrc
AVM_GPL_DIR:=$(BUILD_DIR)/avm_gpl-build-644-359
AVM_GPL_CAT:=zcat

AVM_KERNEL_SOURCE:=kernel-src-462.tar.gz
AVM_KERNEL_DIR:=$(AVM_GPL_DIR)/GPL

LINUX_MODULES_DIR:=$(TARGET_DIR)/lib/modules/2.4.17_mvl21-malta-mips_fp_le
LINUX_HEADERS_DIR:=$(BUILD_DIR)/linux-2.4.17_mvl21
LINUX_DIR:=$(LINUX_HEADERS_DIR)

$(DL_DIR)/$(AVM_GPL_SOURCE): | $(DL_DIR)
	 $(WGET) -P $(DL_DIR) $(AVM_GPL_SITE)/$(AVM_GPL_SOURCE)

avm-gpl-source: $(DL_DIR)/$(AVM_GPL_SOURCE)

$(AVM_GPL_DIR)/.unpacked: $(DL_DIR)/$(AVM_GPL_SOURCE) | $(BUILD_DIR)
	rm -rf $(AVM_GPL_DIR)
	mkdir $(AVM_GPL_DIR)
	$(AVM_GPL_CAT) $(DL_DIR)/$(AVM_GPL_SOURCE) |\
	  tar -C $(AVM_GPL_DIR) $(TAR_OPTIONS) -
	touch $(AVM_GPL_DIR)/.unpacked

avm-gpl: $(AVM_GPL_DIR)/.unpacked

avm-gpl-clean:

avm-gpl-dirclean:
	rm -rf $(AVM_GPL_DIR)

$(LINUX_DIR)/.unpacked: $(AVM_GPL_DIR)/.unpacked
	$(AVM_GPL_CAT) $(AVM_KERNEL_DIR)/$(AVM_KERNEL_SOURCE) |\
	  tar -C $(BUILD_DIR) $(TAR_OPTIONS) - \
	    'kernel_build/kernel/linux-2.4.17_mvl21*' \
	    'kernel_build/Config.Fritz_Box_All'
	rm -rf $(BUILD_DIR)/linux-2.4.17_mvl21
	mv $(BUILD_DIR)/kernel_build/kernel/linux-2.4.17_mvl21 $(BUILD_DIR)
	mv $(BUILD_DIR)/kernel_build/Config.Fritz_Box_All \
	  $(LINUX_DIR)/.config.AVM
	rm -rf $(BUILD_DIR)/kernel_build
	cd $(LINUX_DIR) && \
	  ../../package/avm-gpl/fix-kernel-tree
	toolchain/patch-kernel.sh $(LINUX_DIR) package/avm-gpl/patches
	touch $@

$(LINUX_DIR)/.config: $(LINUX_DIR)/.unpacked
	#cp $(LINUX_DIR)/.config.AVM $@
	cp package/avm-gpl/kernel+modules.config $@

$(LINUX_DIR)/.configured: $(LINUX_DIR)/.config
	$(MAKE) -C $(LINUX_DIR) clean
	$(MAKE) -C $(LINUX_DIR) oldconfig
	ln -sf autoconf.h $(LINUX_DIR)/include/linux/nsp.h
	$(MAKE) -C $(LINUX_DIR) dep
	touch $@

avm-kernelsrc: $(LINUX_DIR)/.configured

avm-kernelsrc-clean:

avm-kernelsrc-dirclean:
	rm -rf $(LINUX_DIR)

$(LINUX_DIR)/ram_zimage_pad.bin: $(LINUX_DIR)/.configured
	PATH=$(TARGET_PATH) \
	  $(MAKE) -C $(LINUX_DIR) DD_BS=256 CROSS_COMPILE=$(TARGET_CROSS) \
	    ram_zimage_pad

avm-kernel: $(LINUX_DIR)/ram_zimage_pad.bin

$(LINUX_MODULES_DIR)/.modules: $(LINUX_DIR)/ram_zimage_pad.bin
	PATH=$(TARGET_PATH) \
	  $(MAKE) -C $(LINUX_DIR) CROSS_COMPILE=$(TARGET_CROSS) modules
	PATH=$(TARGET_PATH) \
	  $(MAKE) -C $(LINUX_DIR) CROSS_COMPILE=$(TARGET_CROSS) \
	  MODLIB=$(LINUX_MODULES_DIR)/tmp modules_install
	cp -a $(LINUX_MODULES_DIR)/tmp/* $(LINUX_MODULES_DIR)
	rm -rf $(LINUX_MODULES_DIR)/tmp
	touch $@

modules: $(LINUX_MODULES_DIR)/.modules
