#############################################################
#
# etherwake
#
#############################################################
ETHERWAKE_VER:=1.08
ETHERWAKE_SOURCE:=etherwake_$(ETHERWAKE_VER).orig.tar.gz
ETHERWAKE_SITE:=ftp://ftp.debian.org/debian/pool/main/e/etherwake/
ETHERWAKE_CAT:=zcat
ETHERWAKE_DIR:=$(BUILD_DIR)/etherwake-$(ETHERWAKE_VER)

$(DL_DIR)/$(ETHERWAKE_SOURCE):
	 $(WGET) -P $(DL_DIR) $(ETHERWAKE_SITE)/$(ETHERWAKE_SOURCE)

etherwake-source: $(DL_DIR)/$(ETHERWAKE_SOURCE)

$(ETHERWAKE_DIR)/ether-wake.c: $(DL_DIR)/$(ETHERWAKE_SOURCE)
	$(ETHERWAKE_CAT) $(DL_DIR)/$(ETHERWAKE_SOURCE) | tar -C $(BUILD_DIR) $(TAR_OPTIONS) -
	rm -rf $(ETHERWAKE_DIR)
	mv $(BUILD_DIR)/etherwake-$(ETHERWAKE_VER).orig $(ETHERWAKE_DIR)
	toolchain/patch-kernel.sh $(ETHERWAKE_DIR) package/etherwake \*.patch

etherwake-unpacked: $(ETHERWAKE_DIR)/ether-wake.c
.PHONY: etherwake-unpacked

$(ETHERWAKE_DIR)/etherwake: $(ETHERWAKE_DIR)/ether-wake.c
	cd $(ETHERWAKE_DIR) && $(TARGET_CC) $(TARGET_CFLAGS) -static-libgcc -o $@ ether-wake.c

$(TARGET_DIR)/sbin/etherwake: $(ETHERWAKE_DIR)/etherwake
	install -D $(ETHERWAKE_DIR)/etherwake $(TARGET_DIR)/sbin/etherwake
	$(STRIP) $(TARGET_DIR)/sbin/etherwake > /dev/null 2>&1

etherwake: uclibc $(TARGET_DIR)/sbin/etherwake 

etherwake-clean: 
	rm -f $(ETHERWAKE_DIR)/etherwake
	rm -f $(TARGET_DIR)/usr/bin/etherwake

etherwake-dirclean: 
	rm -rf $(ETHERWAKE_DIR) 


