#############################################################
#
# ltrace
#
#############################################################
LTRACE_SOURCE=ltrace_0.3.36.orig.tar.gz
LTRACE_SITE=http://ftp.debian.org/debian/pool/main/l/ltrace
LTRACE_DIR=$(BUILD_DIR)/ltrace-0.3.36
LTRACE_BINARY=ltrace
LTRACE_TARGET_BINARY=usr/bin/ltrace

LTRACE_ARCH:=$(ARCH)
ifeq ("$(strip $(ARCH))","armeb")
LTRACE_ARCH:=arm
endif

$(DL_DIR)/$(LTRACE_SOURCE):
	$(WGET) -P $(DL_DIR) $(LTRACE_SITE)/$(LTRACE_SOURCE)

$(LTRACE_DIR)/.source: $(DL_DIR)/$(LTRACE_SOURCE)
	zcat $(DL_DIR)/$(LTRACE_SOURCE) | tar -C $(BUILD_DIR) $(TAR_OPTIONS) -
	touch $(LTRACE_DIR)/.source

$(LTRACE_DIR)/.configured: $(LTRACE_DIR)/.source $(STAGING_DIR)/usr/lib/libelf.a
	(cd $(LTRACE_DIR); \
		CPPFLAGS="-I$(STAGING_DIR)/usr/include/libelf -I$(STAGING_DIR)/usr/include" \
		LIBS="-L$(STAGING_DIR)/usr/lib -lelf" \
		CFLAGS="$(TARGET_CFLAGS)" \
		$(TARGET_CONFIGURE_OPTS) \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--sysconfdir=/etc \
	);
	touch $(LTRACE_DIR)/.configured;

$(LTRACE_DIR)/$(LTRACE_BINARY): $(LTRACE_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) LD=$(TARGET_CROSS)ld ARCH=$(LTRACE_ARCH) \
		-C $(LTRACE_DIR)

$(TARGET_DIR)/$(LTRACE_TARGET_BINARY): $(LTRACE_DIR)/$(LTRACE_BINARY)
	fakeroot $(MAKE) DESTDIR=$(TARGET_DIR) ARCH=$(LTRACE_ARCH) \
		-C $(LTRACE_DIR) install
	rm -Rf $(TARGET_DIR)/usr/man

ltrace: uclibc $(TARGET_DIR)/$(LTRACE_TARGET_BINARY)

ltrace-source: $(DL_DIR)/$(LTRACE_SOURCE)

ltrace-clean:
	rm -r $(TARGET_DIR)/$(LTRACE_TARGET_BINARY)
	-$(MAKE) -C $(LTRACE_DIR) clean

ltrace-dirclean:
	rm -r $(TARGET_DIR)/$(LTRACE_TARGET_BINARY)
	rm -rf $(LTRACE_DIR)

