#############################################################
#
# Makefile for libelf within uClibc buildroot
#
# Copyright (C) 2005 by Enrik Berkhan <Enrik.Berkhan@akk.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU Library General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA

LIBELF_VER:=0.8.5
LIBELF_DIR:=$(BUILD_DIR)/libelf-$(LIBELF_VER)
LIBELF_SITE:=http://www.stud.uni-hannover.de/~michael/software
LIBELF_SOURCE:=libelf-$(LIBELF_VER).tar.gz
LIBELF_CAT:=zcat

$(DL_DIR)/$(LIBELF_SOURCE): | $(DL_DIR)
	 $(WGET) -P $(DL_DIR) $(LIBELF_SITE)/$(LIBELF_SOURCE)

libelf-source: $(DL_DIR)/$(LIBELF_SOURCE)

$(LIBELF_DIR)/Makefile.in: $(DL_DIR)/$(LIBELF_SOURCE) | $(BUILD_DIR)
	$(LIBELF_CAT) $(DL_DIR)/$(LIBELF_SOURCE) | \
	  tar -C $(BUILD_DIR) $(TAR_OPTIONS) -
	touch $@

libelf-unpacked: $(LIBELF_DIR)/Makefile.in
.PHONY: libelf-unpacked

$(LIBELF_DIR)/Makefile: $(LIBELF_DIR)/Makefile.in
	( \
		cd $(LIBELF_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		ac_cv_sizeof_long_long=8 \
		./configure \
			--target=$(GNU_TARGET_NAME) \
			--host=$(GNU_TARGET_NAME) \
			--build=$(GNU_HOST_NAME) \
			--prefix=/usr \
			--exec-prefix=/usr \
			--libexecdir=/usr/lib \
			--sharedstatedir=/var/tmp \
			--localstatedir=/var/tmp \
			--disable-nls \
			--disable-shared \
			--enable-compat \
			--enable-elf64 \
	);

libelf-configured: $(LIBELF_DIR)/Makefile

$(LIBELF_DIR)/lib/libelf.a: $(LIBELF_DIR)/Makefile
	$(MAKE) -C $(LIBELF_DIR)

$(STAGING_DIR)/usr/lib/libelf.a: $(LIBELF_DIR)/lib/libelf.a
	$(MAKE) \
		-C $(LIBELF_DIR) \
		instroot=$(STAGING_DIR) \
		install

libelf: uclibc $(STAGING_DIR)/usr/lib/libelf.a

libelf-clean:
	-$(MAKE) -C $(LIBELF_DIR) clean
	$(MAKE) \
		-C $(LIBELF_DIR) \
		instroot=$(STAGING_DIR) \
		uninstall

libelf-dirclean:
	rm -rf $(LIBELF_DIR)
