#############################################################
#
# Makefile for libpcap within uClibc buildroot
#
# Copyright (C) 2005 by Enrik Berkhan <Enrik.Berkhan@akk.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU Library General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA

LIBPCAP_VER:=0.8.3
LIBPCAP_DIR:=$(BUILD_DIR)/libpcap-$(LIBPCAP_VER)
LIBPCAP_SITE:=http://www.tcpdump.org/release/
LIBPCAP_SOURCE:=libpcap-$(LIBPCAP_VER).tar.gz
LIBPCAP_CAT:=zcat

$(DL_DIR)/$(LIBPCAP_SOURCE): | $(DL_DIR)
	 $(WGET) -P $(DL_DIR) $(LIBPCAP_SITE)/$(LIBPCAP_SOURCE)

libpcap-source: $(DL_DIR)/$(LIBPCAP_SOURCE)

$(LIBPCAP_DIR)/Makefile.in: $(DL_DIR)/$(LIBPCAP_SOURCE) | $(BUILD_DIR)
	$(LIBPCAP_CAT) $(DL_DIR)/$(LIBPCAP_SOURCE) | \
	  tar -C $(BUILD_DIR) $(TAR_OPTIONS) -
	touch $@

libpcap-unpacked: $(LIBPCAP_DIR)/Makefile.in
.PHONY: libpcap-unpacked

$(LIBPCAP_DIR)/Makefile: $(LIBPCAP_DIR)/Makefile.in
	( \
		cd $(LIBPCAP_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		ac_cv_linux_vers=2 \
		./configure \
			--target=$(GNU_TARGET_NAME) \
			--host=$(GNU_TARGET_NAME) \
			--build=$(GNU_HOST_NAME) \
			--prefix=/usr \
			--exec-prefix=/usr \
			--libexecdir=/usr/lib \
			--sysconfdir=/etc \
			--sharedstatedir=/var/tmp \
			--localstatedir=/var/tmp \
			--with-pcap=linux \
	);

libpcap-configured: $(LIBPCAP_DIR)/Makefile

$(LIBPCAP_DIR)/libpcap.a: $(LIBPCAP_DIR)/Makefile
	$(MAKE) -C $(LIBPCAP_DIR)

$(STAGING_DIR)/usr/lib/libpcap.a: $(LIBPCAP_DIR)/libpcap.a
	$(MAKE) \
		-C $(LIBPCAP_DIR) \
		DESTDIR=$(STAGING_DIR) \
		install

libpcap: uclibc $(STAGING_DIR)/usr/lib/libpcap.a

libpcap-clean:
	-$(MAKE) -C $(LIBPCAP_DIR) clean
	$(MAKE) \
		-C $(LIBPCAP_DIR) \
		DESTDIR=$(STAGING_DIR) \
		uninstall

libpcap-dirclean:
	rm -rf $(LIBPCAP_DIR)
