#############################################################
#
# Makefile for tcpdump within uClibc buildroot
#
# Copyright (C) 2005 by Enrik Berkhan <Enrik.Berkhan@akk.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU Library General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA

TCPDUMP_VER:=3.8.3
TCPDUMP_DIR:=$(BUILD_DIR)/tcpdump-$(TCPDUMP_VER)
TCPDUMP_SITE:=http://www.tcpdump.org/release/
TCPDUMP_SOURCE:=tcpdump-$(TCPDUMP_VER).tar.gz
TCPDUMP_CAT:=zcat

$(DL_DIR)/$(TCPDUMP_SOURCE): | $(DL_DIR)
	 $(WGET) -P $(DL_DIR) $(TCPDUMP_SITE)/$(TCPDUMP_SOURCE)

tcpdump-source: $(DL_DIR)/$(TCPDUMP_SOURCE)

$(TCPDUMP_DIR)/Makefile.in: $(DL_DIR)/$(TCPDUMP_SOURCE) | $(BUILD_DIR)
	$(TCPDUMP_CAT) $(DL_DIR)/$(TCPDUMP_SOURCE) | \
	  tar -C $(BUILD_DIR) $(TAR_OPTIONS) -
	touch $@

tcpdump-unpacked: $(TCPDUMP_DIR)/Makefile.in
.PHONY: tcpdump-unpacked

$(TCPDUMP_DIR)/Makefile: $(STAGING_DIR)/usr/lib/libpcap.a
$(TCPDUMP_DIR)/Makefile: $(TCPDUMP_DIR)/Makefile.in
	( \
		cd $(TCPDUMP_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		LDFLAGS="-static-libgcc" \
		ac_cv_linux_vers=2 \
		./configure \
			--target=$(GNU_TARGET_NAME) \
			--host=$(GNU_TARGET_NAME) \
			--build=$(GNU_HOST_NAME) \
			--prefix=/usr \
			--exec-prefix=/usr \
			--libexecdir=/usr/lib \
			--sysconfdir=/etc \
			--sharedstatedir=/var/tmp \
			--localstatedir=/var/tmp \
			--infodir=/usr/info \
			--mandir=/usr/man \
			--without-crypto \
			--disable-ipv6 \
			--disable-smb \
	);

tcpdump-configured: $(TCPDUMP_DIR)/Makefile

$(TCPDUMP_DIR)/tcpdump: $(TCPDUMP_DIR)/Makefile
	$(MAKE) -C $(TCPDUMP_DIR)

$(TARGET_DIR)/usr/sbin/tcpdump: $(TCPDUMP_DIR)/tcpdump
	$(MAKE) -C $(TCPDUMP_DIR) DESTDIR=$(TARGET_DIR) install
	$(STRIP) $@

tcpdump: uclibc $(TARGET_DIR)/usr/sbin/tcpdump

tcpdump-clean:
	-$(MAKE) -C $(TCPDUMP_DIR) DESTDIR=$(TARGET_DIR) uninstall
	-$(MAKE) -C $(TCPDUMP_DIR) clean

tcpdump-dirclean:
	rm -rf $(TCPDUMP_DIR)
