#############################################################
#
# mksquashfs to build target squashfs filesystems
#
#############################################################
SQUASHFS2_DIR=$(BUILD_DIR)/squashfs2.1-r2
SQUASHFS2_SOURCE=squashfs2.1-r2.tar.gz
SQUASHFS2_SITE=http://aleron.dl.sourceforge.net/sourceforge/squashfs

FBOXFW_DIR=$(BUILD_DIR)/fboxfw
#FBOXFW_SOURCE2=fritz.box_fon_wlan.08.03.29.image
FBOXFW_SOURCE=fritz.box_fon_ata.11.03.37.image
#FBOXFW_SITE2=ftp://ftp.avm.de/cardware/fritzbox.fon_wlan/firmware
FBOXFW_SITE=ftp://ftp.avm.de/cardware/fritz!box.fon_ata/firmware

$(DL_DIR)/$(SQUASHFS2_SOURCE):
	$(WGET) -P $(DL_DIR) $(SQUASHFS2_SITE)/$(SQUASHFS2_SOURCE)

$(DL_DIR)/$(FBOXFW_SOURCE):
	$(WGET) --passive-ftp -P $(DL_DIR) $(FBOXFW_SITE)/$(FBOXFW_SOURCE)
ifneq ($(FBOXFW_SOURCE2),)
	$(WGET) --passive-ftp -P $(DL_DIR) $(FBOXFW_SITE2)/$(FBOXFW_SOURCE2)
endif

$(SQUASHFS2_DIR)/.source: $(DL_DIR)/$(SQUASHFS2_SOURCE) #$(SQUASHFS2_PATCH)
	zcat $(DL_DIR)/$(SQUASHFS2_SOURCE) | tar -C $(BUILD_DIR) -xvf -
	#toolchain/patch-kernel.sh $(SQUASHFS2_DIR) target/fritz/ squashfs.patch
	touch $@

$(FBOXFW_DIR)/.unpacked: $(DL_DIR)/$(FBOXFW_SOURCE)
	-mkdir -p $(FBOXFW_DIR)/root-fs
	-chmod -R u+w $(FBOXFW_DIR)/root-fs
	-rm -rf $(FBOXFW_DIR)/root-fs/*
ifneq ($(FBOXFW_SOURCE2),)
	tar -C $(FBOXFW_DIR) -xf $(DL_DIR)/$(FBOXFW_SOURCE2) \
	  ./var/tmp/filesystem.image 
	mv $(FBOXFW_DIR)/var/tmp/filesystem.image \
	  $(FBOXFW_DIR)/var/tmp/filesystem.image.2
endif
	tar -C $(FBOXFW_DIR) -xf $(DL_DIR)/$(FBOXFW_SOURCE)
	touch $@

$(SQUASHFS2_DIR)/squashfs-tools/mksquashfs: $(SQUASHFS2_DIR)/.source
	$(MAKE) -C $(SQUASHFS2_DIR)/squashfs-tools;

squashfs2: $(SQUASHFS2_DIR)/squashfs-tools/mksquashfs

squashfs2-source: $(DL_DIR)/$(SQUASHFS2_SOURCE)

squashfs2-clean:
	-$(MAKE) -C $(SQUASHFS2_DIR)/squashfs-tools clean

squashfs2-dirclean:
	rm -rf $(SQUASHFS2_DIR)

fboxfw: $(FBOXFW_DIR)/.unpacked

fboxfw-source: $(DL_DIR)/$(FBOXFW_SOURCE)

fboxfw-dirclean:
	rm -rf $(FBOXFW_DIR)

#############################################################
#
# Build the fritzbox root filesystem image
#
#############################################################

MTD_DEPENDS := $(SQUASHFS2_DIR)/squashfs-tools/mksquashfs \
	$(LINUX_DIR)/ram_zimage_pad.bin \
	$(LINUX_MODULES_DIR)/.modules \
	target/fritz/exclude.list \
	$(BUILD_DIR)/root/bin/busybox | $(TARGET_DIR)

kernel.image filesystem.image: $(MTD_DEPENDS)
	perl $(BUSYBOX_DIR)/examples/depmod.pl -k $(LINUX_DIR)/vmlinux -b $(LINUX_MODULES_DIR)
	chmod -R go-w $(TARGET_DIR)
	fakeroot busybox tar cvf $(LINUX_MODULES_DIR)/kernel/hidden/var.tar -C $(TARGET_DIR) ./var || \
	busybox tar cvf $(LINUX_MODULES_DIR)/kernel/hidden/var.tar -C $(TARGET_DIR) ./var
	rm -rf $(BUILD_DIR)/tmproot
	mkdir -p $(BUILD_DIR)/tmproot
	tar cf - -X target/fritz/exclude.list -C $(TARGET_DIR) . | tar xf - -C $(BUILD_DIR)/tmproot
	tar cf - -C target/fritz/add-files . | tar xf - -C $(BUILD_DIR)/tmproot
	$(SQUASHFS2_DIR)/squashfs-tools/mksquashfs $(BUILD_DIR)/tmproot \
	  fs.tmp -noappend -root-owned
	rm -rf $(BUILD_DIR)/tmproot
	@ls -l $(LINUX_DIR)/ram_zimage_pad.bin | \
	  awk '$$5 > 11 * 64 * 1024 { print "kernel too large! ABORT!"; exit 1 }'
	cat $(LINUX_DIR)/ram_zimage_pad.bin fs.tmp > img.tmp
	rm -f fs.tmp 
	dd if=img.tmp of=kernel.image bs=64k count=11 conv=sync
	dd if=img.tmp of=filesystem.image bs=64k skip=11 conv=sync
	rm -f img.tmp 
	@ls -l filesystem.image | \
	  if ! awk '$$5 > 48 * 64 * 1024 { print "filesystem.image too large! ABORT!"; exit 1 }' ; then rm filesystem.image; exit 1 ; fi

fritzboximage: kernel.image filesystem.image

fritzboximage-clean:
	kernel.image filesystem.image

